/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIXMLHttpRequest;

/*
 * This object represents an XHR Call.
 */
public class MozXHRCall extends MozHTTPCall{
	
	public MozXHRCall() {
		super();
	}
	
	protected MozHTTPRequest createRequest( nsIHttpChannel httpChannel ){
		return new MozHTTPRequest( httpChannel, true );
	}
	
	/**
	 * This method is called to set the information about the response
	 * side of the HTTP call.
	 * 
	 * @param in the case of an onError handler, need to bypass creating the response object
	 */
	public void captureResponse( nsIXMLHttpRequest xhr, boolean error ){
		
		try{
			
			if( !error ){
				nsIHttpChannel httpChannel = (nsIHttpChannel) (xhr.getChannel()
						.queryInterface(nsIHttpChannel.NS_IHTTPCHANNEL_IID));
				captureResponse( httpChannel );
				
				//The XHR carries the response text so might as well set it here
				((MozHTTPResponse)response).setBody( xhr.getResponseText() );
			}
			else{
				endTime = System.currentTimeMillis();
			}
		}
		catch( Exception e ){
			state = ERROR_STATE;
			endTime = System.currentTimeMillis();
		}
	}
	
}
