package org.eclipse.atf.mozilla.ide.ui.preferences;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;

public interface IPreferenceConstants {
	
	/**
	 * This preference is used to determine what to do when a browser popup is detected.
	 * 
	 * Values:
	 * 
	 * IPreferenceConstants.POPUP_HANDLING_AS_EDITOR - Open popup as another Browser editor
	 * IPreferenceConstants.POPUP_HANDLING_AS_DIALOG - Open popup in a Dialog
	 * IPreferenceConstants.POPUP_HANDLING_IGNORE - Ignore the popup
	 * IPreferenceConstants.POPUP_HANDLING_PROMPT - Ask the end-user
	 */
	static final String POPUP_HANDLING = MozIDEUIPlugin.ID + "popupHandling";
	
	static final String POPUP_HANDLING_AS_EDITOR = "editor";
	static final String POPUP_HANDLING_AS_DIALOG = "dialog";
	static final String POPUP_HANDLING_IGNORE = "ignore";
	static final String POPUP_HANDLING_PROMPT = "prompt";
	
}
