package org.eclipse.atf.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;

public abstract class AbstractOpenWizardAction implements IWorkbenchWindowActionDelegate
{

	private IWorkbenchWindow window;

	public AbstractOpenWizardAction()
	{
		super();
	}

	public void dispose()
	{
		// TODO Auto-generated method stub
	}

	public void init( IWorkbenchWindow window )
	{
		this.window = window;
	}

	abstract public void run( IAction action );

	public void selectionChanged( IAction action, ISelection selection )
	{
		// TODO Auto-generated method stub
	}

	protected void openWizardDialog( IWorkbenchWizard wizard )
	{
		ISelection selection = window.getSelectionService().getSelection();
	
		if ( selection instanceof IStructuredSelection )
		{
			wizard.init( window.getWorkbench(), (IStructuredSelection) selection );
		}
		else
		{
			wizard.init( window.getWorkbench(), StructuredSelection.EMPTY );
		}
	
		Shell parent = window.getShell();
		WizardDialog dialog = new WizardDialog( parent, wizard );
	
		dialog.create();
		dialog.open();
	}

}