package org.eclipse.atf.ui.debug;

import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.preferences.JSDebugPreferenceNames;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class DebugPreferencesGroup implements PreferencesConfigGroup, SelectionListener {

	private Button suspendStart;
	private Button suspendKeyword;
	private Button suspendError;
	private Button suspendException;
	private Button useConfig;
	private Group group;
	private Composite useConfigComp;
	private ILaunchConfiguration config;
	private WebLaunchConfigurationTab tab;
	
	public DebugPreferencesGroup(Composite parent, WebLaunchConfigurationTab tab, int style) {
		group = new Group(parent,style);
		group.setText("Debug Preferences");
		group.setFont(parent.getFont());
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		group.setLayout(gridLayout);
		group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		
		useConfigComp = new Composite(group, SWT.NULL);
		useConfigComp.setLayout(gridLayout);
		useConfig = new Button(useConfigComp, SWT.CHECK);
		useConfig.setText("Use launch specific options");
		useConfig.setSelection(false);
		useConfig.addSelectionListener(this);
		
		Composite checks = new Composite(useConfigComp, SWT.NONE);
		gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.marginLeft = 10;
		checks.setLayout(gridLayout);
		suspendStart = new Button(checks, SWT.CHECK);
		suspendStart.setText("Suspend at start");
		suspendStart.addSelectionListener(this);
		suspendKeyword = new Button(checks, SWT.CHECK);
		suspendKeyword.setText("Suspend on debugger keyword");
		suspendKeyword.addSelectionListener(this);
		suspendError = new Button(checks, SWT.CHECK);
		suspendError.setText("Suspend on error");
		suspendError.addSelectionListener(this);
		suspendException = new Button(checks, SWT.CHECK); 
		suspendException.setText("Suspend on exception");
		suspendException.addSelectionListener(this);
		this.tab = tab;
	}

	public void useConfiguration(ILaunchConfiguration config) {
		useConfig.setSelection(true);
		try {
			suspendStart.setSelection(config.getAttribute(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE, false ));
			suspendKeyword.setSelection(config.getAttribute(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD, false ));
			suspendError.setSelection(config.getAttribute(JSDebugPreferenceNames.SUSPEND_ON_ERRORS, false ));
			suspendException.setSelection(config.getAttribute(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS, false));
		} catch( CoreException ce ) {
			ce.printStackTrace();
		}
		suspendStart.setEnabled(true);
		suspendKeyword.setEnabled(true);
		suspendError.setEnabled(true);
		suspendException.setEnabled(true);
	}

	public void usePreferences(Preferences preferences) {
		useConfig.setSelection(false);
		suspendStart.setSelection(preferences.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE));
		suspendKeyword.setSelection(preferences.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD));
		suspendError.setSelection(preferences.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_ERRORS));
		suspendException.setSelection(preferences.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS));
		suspendStart.setEnabled(false);
		suspendKeyword.setEnabled(false);
		suspendError.setEnabled(false);
		suspendException.setEnabled(false);
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		
	}
	
	public void initialize( ILaunchConfiguration config ) {
		try {
			this.config = config;
			if( config.getAttribute(JSDebugPreferenceNames.OVERRIDE_PREFERENCES, false) ) {
				useConfiguration(config);
			} else {
				usePreferences(MozillaDebugPlugin.getDefault().getPluginPreferences());
			}
		} catch( CoreException ce ) {
			
		}
	}

	public void widgetSelected(SelectionEvent e) {
		if( e.getSource().equals(useConfig)) {
			if( !useConfig.getSelection() ) {
				usePreferences( MozillaDebugPlugin.getDefault().getPluginPreferences() );
			} else {
				useConfiguration(config);
			}
		}
		tab.update();
	}

	public void apply(ILaunchConfigurationWorkingCopy workingConfig) {
		workingConfig.setAttribute(JSDebugPreferenceNames.OVERRIDE_PREFERENCES, useConfig.getSelection());
		if( useConfig.getSelection() ) {
			workingConfig.setAttribute(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE, suspendStart.getSelection());
			workingConfig.setAttribute(JSDebugPreferenceNames.SUSPEND_ON_ERRORS, suspendError.getSelection());
			workingConfig.setAttribute(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS, suspendException.getSelection());
			workingConfig.setAttribute(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD, suspendKeyword.getSelection());
		}
	}

}
