/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.ui.debug;

import java.net.URL;

import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserProcess;
import org.eclipse.atf.mozilla.ide.ui.browser.util.MozBrowserUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;

// RSG - Just copy MozillaDebugJob and modify it for PHP. 
// This is a hack, needs to change for a product. 

public class MozillaDebugPHP {

	protected ILaunch launch;
	protected URL url;
	
	public MozillaDebugPHP(ILaunch launch, URL url) {
		this.launch = launch;
		this.url = url;
	}
	
	Browser debugBrowser;
	public void launchApp() throws CoreException {
		
		// RSG - Some code to get info required by ATF from the PHP launch configuration. 

		ILaunchConfiguration configuration = launch.getLaunchConfiguration();
		String fileName = configuration.getAttribute("file_name" /* org.eclipse.php.internal.server.core.Server - RSG ??? */, (String) null);
		String name = configuration.getAttribute("name" /* org.eclipse.php.internal.server.core.Server - RSG ??? */, (String) null);
/*		Map attrs = configuration.getAttributes();
		Set set = attrs.keySet();
		Object[] keys = set.toArray();
		for (int i=0; i<keys.length; i++){
			System.out.println("Keys: " + keys[i]);
		} */
		// Get the project from the file name
		IPath filePath = new Path(fileName);
		IProject project = null;
		try {
			project = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
		} catch (Throwable t) {
		}
		if (project == null) {
			System.out.println( "Could not execute the debug (Project is null).");
			return;
		}
		
		IPath releativePath = filePath.removeFirstSegments(1);
		String appPath = releativePath.toString();
		
/*		ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
		String projectName = project.getName();
		wc.setAttribute(ILaunchConfigurationConstants.PROJECT, projectName);
		IPath releativePath = filePath.removeFirstSegments(1);
		String appPath = releativePath.toString();
		if (appPath.startsWith("/"))appPath = appPath.substring(1);
		wc.setAttribute(ILaunchConfigurationConstants.APP_PATH, appPath);
		wc.doSave(); */
					
		// XPCOM calls in the debugger will be delegated to the Display thread by this helper object
		Display display = Display.getDefault();
		IXPCOMThreadProxyHelper proxyHelper = new XPCOMThreadProxyHelper(display);
		
		proxyHelper.syncExec(new Runnable() {
			public void run() {
				
				try {					
					debugBrowser = MozBrowserUtil.openMozillaBrowser( "about:blank" );
				} catch (CoreException e) {
					e.printStackTrace();
					return;
				}
				
			}
		});
		
		// Start the debugger on the Display thread
		final JSDebugTarget debugTarget = (JSDebugTarget)MozillaDebugPlugin.launchDebugTarget(launch, url, project, appPath, new NestedEventLoop(display), proxyHelper);
		launch.addDebugTarget(debugTarget);

		//RSG - another Hack, put the source locator in launch configuration, so
		// 		it can be found by JSSourceLookupParticipant
		// don't set the source locator in launch. There can be only one
		// and will cause problems when running with PHP. Lets set in debug target
		// for now. this need to be changed since the file is not longer needed as
		// a source locator. 
		final JSSourceLocator locator = new JSSourceLocator();
		String projectName = project.getName();
		if (locator != null && locator instanceof JSSourceLocator) {
			JSSourceLocator jslocator = (JSSourceLocator)locator;
			jslocator.setProject(project);
			String appBase = url.toExternalForm().substring(0, url.toExternalForm().indexOf(appPath));
			jslocator.setAppBase(appBase);
		}		
		
		// Open the application in a browser on the same Display thread
		proxyHelper.syncExec(new Runnable() {
			public void run() {
				
				System.out.println(" url to string " + url.toString());
				System.out.println(" url to toExternalForm " + url.toExternalForm());
				
				debugBrowser.setUrl( url.toString() );
				//Process adds itself to the launch
				debugTarget.setProcess(new MozBrowserProcess(debugBrowser, launch));
				debugTarget.setSourceLocator(locator);
				
			}
		});
			
	}
	
	public static void openBrowser(String url){
		try {
			MozBrowserUtil.openMozillaBrowser( url );
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	
	public static void xdebugReset(final String url) {

		// can't invoke this on the UI Thread
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				try {
					MozBrowserUtil.openMozillaBrowser( url );
				} catch (CoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			}
		});
	}

}
