package org.eclipse.atf.ui.facet;

import org.eclipse.atf.facet.ATFFacetInstallConfig;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.ui.runtime.ToolkitSelectionField;
import org.eclipse.atf.ui.runtime.standins.RuntimeContainerStandin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;

public class ToolkitSelectionPage extends AbstractFacetWizardPage
{
	private static final String PAGE_TITLE = "AJAX Toolkit Project";
	private static final String PAGE_DESCRIPTION = "Configure AJAX Toolkit module settings.";
	private static final String PAGE_TEXT_1 = "Select the JavaScript toolkit to use in your project:";

	private ATFFacetInstallConfig config;
	private RuntimeContainerStandin runtimeContainerStandin;
	private ToolkitSelectionField selector;

	public ToolkitSelectionPage()
	{
		super( "atf.facet.install.page" );
		setTitle( PAGE_TITLE );
		setDescription( PAGE_DESCRIPTION );

		runtimeContainerStandin = new RuntimeContainerStandin();
	}

	public void createControl( Composite parent )
	{
		final Composite composite = new Composite( parent, SWT.NONE );

		// create layout for control
		GridLayout gridLayout = new GridLayout();
		composite.setLayout( gridLayout );

		// explanatory text
		Label label = new Label( composite, SWT.NONE );
		label.setText( PAGE_TEXT_1 );

		// create toolkit selection table and buttons
		selector = new ToolkitSelectionField( false, SWT.CHECK )
		{
			protected void setStatus( IStatus status )
			{
				if ( status.getSeverity() == IStatus.OK )
				{
					setErrorMessage( null );
					setPageComplete( true );
					return;
				}
				
				// severity is ERROR
				setErrorMessage( status.getMessage() );
				setPageComplete( false );
			}
		};
		selector.createControl( composite );

		GridData data = new GridData( SWT.FILL, SWT.FILL, true, true );
		selector.setLayoutData( data );

		// set input
		selector.setInput( runtimeContainerStandin );

		// Initially, no toolkit is set.  Disable finish/next buttons and
		// display error message.
		setErrorMessage( ToolkitSelectionField.ERROR_NO_TOOLKIT_SELECTED_MSG );
		setPageComplete( false );
		
		setControl( composite );
	}

	public void setConfig( Object config )
	{
		this.config = (ATFFacetInstallConfig) config;
	}

	public void transferStateToConfig()
	{
		config.setToolkits( selector.getCheckedElements() );
	}
}
