package org.eclipse.atf.ui.perspective;

import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.progress.IProgressConstants;

public class WebDevelopmentPerspective implements IPerspectiveFactory {

public static final String ID = "org.eclipse.ui.atf.webDevPerspective"; //$NON-NLS-N$
	
	protected static final String TOP_LEFT_LOCATION = "topLeft"; //$NON-NLS-N$
	protected static final String BOTTOM_LEFT_LOCATION = "bottomLeft"; //$NON-NLS-N$
	protected static final String BOTTOM_RIGHT_LOCATION = "bottomRight"; //$NON-NLS-N$
	protected static final String TOP_RIGHT_LOCATION = "topRight"; //$NON-NLS-N$
	protected static final String BOTTOM_LOCATION = "bottom"; //$NON-NLS-N$
	
	//view id's
	protected static final String ID_PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer"; //$NON-NLS-N$
	protected static final String ID_SERVER = "org.eclipse.wst.server.ui.ServersView";
	
	/*
	 *   ____ ________________ _____
	 *  |    |                |     |
	 *  |    |                |  O  |
	 *  |    |     ED         |     |
	 *  | PE |                |     |
	 *  |    |                |     |
	 *  |    |________________|     |
	 *  |    |                |     |
	 *  |    | PROB/SERV/PROP |     |
	 *  |____|________________|_____|
	 * 
	 */
	public void createInitialLayout(IPageLayout layout) {
		//everything is based off the editor area
		String editorArea = layout.getEditorArea();

//		LEFT Area (Project Explorer)
		IFolderLayout topLeft = layout.createFolder(TOP_LEFT_LOCATION, IPageLayout.LEFT, 0.20f, editorArea);
		topLeft.addView(ID_PROJECT_EXPLORER);
		topLeft.addPlaceholder( IPageLayout.ID_RES_NAV );
		
//		TOP RIGHT Area (Outline)
		IFolderLayout topRight = layout.createFolder(TOP_RIGHT_LOCATION, IPageLayout.RIGHT, 0.80f, editorArea);	
		topRight.addView( IPageLayout.ID_OUTLINE );
		
//		BOTTOM Area (Problems, Server, Properties)
		IFolderLayout bottom = layout.createFolder( BOTTOM_LOCATION, IPageLayout.BOTTOM, 0.70f, editorArea );
		bottom.addView( IPageLayout.ID_PROBLEM_VIEW );
		bottom.addView( ID_SERVER );
		bottom.addView( IPageLayout.ID_PROP_SHEET );
		bottom.addPlaceholder( NewSearchUI.SEARCH_VIEW_ID );
		bottom.addPlaceholder( IConsoleConstants.ID_CONSOLE_VIEW );
		bottom.addPlaceholder( IPageLayout.ID_BOOKMARKS );
		bottom.addPlaceholder( IProgressConstants.PROGRESS_VIEW_ID );
		bottom.addPlaceholder( IPageLayout.ID_TASK_LIST );
	}

}
