package org.eclipse.atf.ui.runtime;

import org.eclipse.atf.ui.runtime.standins.RuntimeContainerStandin;
import org.eclipse.atf.ui.runtime.standins.RuntimeStandin;
import org.eclipse.atf.ui.util.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddRuntimeTypeDialog extends StatusDialog {

	protected Text nameText = null;
	protected Text idText = null;
	
	//validation status
	protected IStatus [] validationStatus = new IStatus[2];
	protected static final int NAME_STATUS = 0;
	protected static final int ID_STATUS = 1;
	
	//Strings
	private static final String NAME_LABEL_TEXT = "Name:";
	private static final String NAME_TOOLTIP = "Name is a pretty name used in the UI.";
	private static final String ID_LABEL_TEXT = "Id:";
	private static final String ID_TOOLTIP = "ID is a lowercase simple string used for identification.";
	
	//instance for editing
	protected RuntimeContainerStandin runtimeContainerStandin = null;
	protected RuntimeStandin editR = null;
	
	public AddRuntimeTypeDialog(Shell parent, RuntimeContainerStandin runtimeContainerStandin, RuntimeStandin editR ) {
		super(parent);
		
		this.runtimeContainerStandin = runtimeContainerStandin;
		
		this.editR = editR;
		
	}
	
	public void create() {
		super.create();
		nameText.setFocus();
		
		/*
		 * Force an update because the superclass would not allow to start with errors
		 */
		updateStatusLine();
		
	}

	protected Control createDialogArea(Composite parent) {
		
		Composite displayArea = (Composite)super.createDialogArea(parent);
		((GridLayout)displayArea.getLayout()).numColumns= 3;
		
		/*
		 * Runtime name
		 */
		Label nameLabel = new Label( displayArea, SWT.LEFT | SWT.WRAP );
		nameLabel.setFont( displayArea.getFont() );
		nameLabel.setText( NAME_LABEL_TEXT );
		
		GridData layoutData = new GridData();
		layoutData.horizontalSpan = 1;
		layoutData.horizontalAlignment = GridData.FILL;
		nameLabel.setLayoutData(layoutData);
		
		nameText = new Text( displayArea, SWT.SINGLE | SWT.BORDER );
		nameText.setFont( displayArea.getFont() );
		nameText.setToolTipText( NAME_TOOLTIP );
		nameText.setTextLimit( 30 );
		
		if( editR != null ){
			nameText.setText( editR.getName() );
		}
		
		nameText.addModifyListener( new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				validationStatus[NAME_STATUS] = validateName();
				updateStatusLine();
			}
		});
		
		layoutData = new GridData();
		layoutData.horizontalSpan = 2;
		layoutData.horizontalAlignment = GridData.FILL;
		layoutData.grabExcessHorizontalSpace = true;
		layoutData.widthHint = convertWidthInCharsToPixels(50);
		nameText.setLayoutData(layoutData);
		
		/*
		 * Runtime id
		 */
		Label idLable = new Label( displayArea, SWT.LEFT | SWT.WRAP );
		idLable.setFont( displayArea.getFont() );
		idLable.setText( ID_LABEL_TEXT );
		idLable.setToolTipText( ID_TOOLTIP );
		
		layoutData = new GridData();
		layoutData.horizontalSpan = 1;
		layoutData.horizontalAlignment = GridData.FILL;
		idLable.setLayoutData(layoutData);
		
		/*
		 * @GINO: TODO need to put constrains and validation in this input field
		 * 
		 * everything will be lowercase
		 * no spaces
		 * only alpha numeric a-z and 0-9
		 */
		idText = new Text( displayArea, SWT.SINGLE | SWT.BORDER );
		idText.setFont( displayArea.getFont() );
		idText.setTextLimit( 20 );
		
		if( editR != null ){
			//extracting the last section of the id
			String runtimeId = editR.getId();
			
			int idxLastDot = runtimeId.lastIndexOf( '.' );
			
			if( idxLastDot != -1 )
				idText.setText( runtimeId.substring( idxLastDot+1 ) );
			else
				idText.setText( runtimeId );
			
			
		}
		
		idText.addModifyListener( new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				validationStatus[ID_STATUS] = validateId();
				updateStatusLine();
			}
		});
		
		layoutData = new GridData();
		layoutData.horizontalSpan = 2;
		layoutData.horizontalAlignment = GridData.FILL;
		layoutData.grabExcessHorizontalSpace = true;
		layoutData.widthHint = convertWidthInCharsToPixels(50);
		idText.setLayoutData(layoutData);
		
		
		//do the intial validation pass
		initValidationStatus();
		updateStatusLine();
		
		return displayArea;
	}
	
	protected void initValidationStatus(){		
		validationStatus[NAME_STATUS] = validateName();	
		validationStatus[ID_STATUS] = validateId();		
	}
	
	/*
	 * Sends the worst status to the status line
	 */
	protected void updateStatusLine() {
		IStatus max= null;
		for (int i= 0; i < validationStatus.length; i++) {
			IStatus curr= validationStatus[i];
			if (curr.matches(IStatus.ERROR)) {
				updateStatus(curr);
				return;
			}
			if (max == null || curr.getSeverity() > max.getSeverity()) {
				max= curr;
			}
		}
		updateStatus(max);
	}
	
		
	protected void okPressed() {
		
		//is an edit
		if( editR != null ){
			String name = nameText.getText();
			String id = idText.getText();
			
			editR.setName( name );
			
			//if it is '.' separated, just change the last part
			
			String runtimeId = editR.getId();
			
			int idxLastDot = runtimeId.lastIndexOf( '.' );
			
			if( idxLastDot != -1 ){
				id = runtimeId.substring( 0, idxLastDot ) + "." + id;
			}			
			editR.setId( id );
			
		}
		//is a new instance
		else{
			
			String name = nameText.getText();
			String id = idText.getText();
			
			RuntimeStandin newR = new RuntimeStandin( System.currentTimeMillis() + "." + id, name );
			runtimeContainerStandin.addRuntime( newR );
		}
		
		super.okPressed();
	}
	
	protected IStatus validateName(){
		StatusInfo status = new StatusInfo();
				
		String name = nameText.getText();
		
		if( name == null || name.equals("") ){
			status.setError( "Name must be set" );
			return status;
		}
		
		return status;
	}
	
	protected IStatus validateId(){
		StatusInfo status = new StatusInfo();
				
		String id = idText.getText();
		
		if( id == null || id.equals("") ){
			status.setError( "Id must be set" );
			return status;
		}
		
		//@GINO: TODOcheck to see if the id is not already in use or that it have valid characters
				
		return status;
	}
}
