package org.eclipse.atf.ui.runtime;

import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.ui.runtime.standins.RuntimeContainerStandin;
import org.eclipse.atf.ui.runtime.standins.RuntimeInstanceStandin;
import org.eclipse.atf.ui.runtime.standins.RuntimeStandin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class InstalledRuntimePreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	
	private static final String PAGE_TITLE = "AJAX Toolkits";
	private static final String PAGE_DESC = "Add, remove or edit AJAX Toolkits.";
	
	private static final String NEW_AJAX_TOOLKIT_DIALOG_TITLE = "New AJAX Toolkit";
	private static final String EDIT_AJAX_TOOLKIT_DIALOG_TITLE = "Edit AJAX Toolkit";
	
	//Strings
	private static final String ADD_BUTTON_TEXT = "Add...";
	private static final String EDIT_BUTTON_TEXT = "Edit...";
	private static final String REMOVE_BUTTON_TEXT = "Remove";
	
	protected RuntimeContainerStandin inputProvider = null;
	protected ToolkitSelectionField selector;
	
	protected Button addButton;
	protected Button removeButton;
	protected Button editButton;
	protected Button defaultButton;
	
	public InstalledRuntimePreferencePage()
	{
		super();
		
		inputProvider = new RuntimeContainerStandin();
		
		setTitle( PAGE_TITLE );
		setDescription( PAGE_DESC );
		noDefaultAndApplyButton();
	}
	
	protected Control createContents( Composite parent )
	{
        final Composite composite = new Composite( parent, SWT.NONE );
        
		// create layout for control
		GridLayout gridLayout = new GridLayout();
		composite.setLayout( gridLayout );

		// create toolkit selection table and buttons
		selector = new ToolkitSelectionField( true, SWT.NONE ) {

			protected Control createButtons( Composite parent )
			{
				Composite buttons = new Composite( parent, SWT.NONE );
				initializeDialogUnits( parent );

				GridData layoutData = new GridData( GridData.FILL, GridData.FILL, false, true );
				buttons.setLayoutData( layoutData );
				
				GridLayout layout = new GridLayout();
				layout.marginHeight= 0;
				layout.marginWidth= 0;
				buttons.setLayout( layout );
				
				addButton = createPushButton( buttons, ADD_BUTTON_TEXT ); 
				addButton.addListener( SWT.Selection, new Listener() {
					public void handleEvent( Event event )
					{
						InstalledRuntimePreferencePage.this.handleAddButton();
					}
				});
				
				editButton = createPushButton( buttons, EDIT_BUTTON_TEXT );
				editButton.addListener( SWT.Selection, new Listener() {
					public void handleEvent(Event event)
					{
						handleEditButton();
					}
				});
				
				removeButton = createPushButton( buttons, REMOVE_BUTTON_TEXT );
				removeButton.addListener( SWT.Selection, new Listener() {
					public void handleEvent(Event event)
					{
						handleRemoveButton();
					}
				});
				
				return buttons;
			}

		};
		selector.createControl( composite );
		
		GridData data = new GridData( SWT.FILL, SWT.FILL, true, true );
		selector.setLayoutData( data );

		// handle button enablement depending on table selection
		selector.addSelectionChangedListener( new ISelectionChangedListener() {

			public void selectionChanged( SelectionChangedEvent event )
			{
				handleButtonEnablement();
			}
			
		});

		// set input
		selector.setInput( inputProvider );

		handleButtonEnablement();

		return composite;
	}
		
	protected Button createPushButton( Composite parent, String label )
	{
		Button button = new Button( parent, SWT.PUSH );
		button.setFont( parent.getFont() );
		setButtonLayoutData( button );
		button.setText( label );
		return button;
	}

	public void init(IWorkbench workbench){}

	public boolean performOk()
	{
		BusyIndicator.showWhile(null, new Runnable() {
			public void run() {
				//	commit all changes to the real runtime model
				inputProvider.commitChanges();	
			}
		});
		
		return super.performOk();
	}	
	
	/*
	 * Method used to set the enable state of buttons depending on the current selection
	 * on the tree viewer.
	 */
	protected void handleButtonEnablement()
	{
		boolean isEmpty = selector.getSelection().isEmpty();
   		editButton.setEnabled( ! isEmpty );
       	removeButton.setEnabled( ! isEmpty );
	}
	
	protected void handleAddButton()
	{
		AddRuntimeInstanceDialog dialog = new AddRuntimeInstanceDialog( getShell(), inputProvider, null );
		dialog.setTitle( NEW_AJAX_TOOLKIT_DIALOG_TITLE );
		
		if (dialog.open() != Window.OK) {
			return;
		}
		
		selector.refresh();
	}
	
	protected void handleEditButton()
	{
		IStructuredSelection selection = (IStructuredSelection) selector.getSelection();

		IRuntimeInstance toBeEdited = (IRuntimeInstance) selection.getFirstElement();
    	AddRuntimeInstanceDialog dialog = new AddRuntimeInstanceDialog( getShell(), inputProvider, (RuntimeInstanceStandin) toBeEdited );
		dialog.setTitle( EDIT_AJAX_TOOLKIT_DIALOG_TITLE );
		
		if (dialog.open() != Window.OK) {
			return;
		}
		
		selector.refresh( toBeEdited );
	}
	
	protected void handleRemoveButton()
	{
		IStructuredSelection selection = (IStructuredSelection) selector.getSelection();
       	RuntimeInstanceStandin toBeRemoved = (RuntimeInstanceStandin) selection.getFirstElement();
       	((RuntimeStandin) toBeRemoved.getType()).removeInstance( toBeRemoved );

       	selector.refresh();
	}
	
}
