package org.eclipse.atf.ui.runtime.standins;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.IRuntimeContainer;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.IRuntimeInstanceContainer;
import org.eclipse.atf.runtime.Runtime;
import org.eclipse.atf.runtime.RuntimeManager;

public class RuntimeContainerStandin implements IRuntimeContainer, IRuntimeInstanceContainer {
	
	/*
	 * Map of all the supported Rutimes keyed by id
	 */
	protected HashMap runtimeMap = new HashMap();
	
	protected IRuntime latestRuntimeAdded = null;
	
	/* Constructs a temporary copy of the runtime model that can be edited
	 * by the Pref pages. This way changes made by end-user are not commited
	 * back to the real model until OK is pressed on the Pref page.
	 */
	public RuntimeContainerStandin(){
		
		IRuntime [] runtimes = RuntimeManager.getInstance().getRuntimes();
		
		//create the Runtime standins
		for (int i = 0; i < runtimes.length; i++) {
			runtimeMap.put( runtimes[i].getId() , new RuntimeStandin((Runtime)runtimes[i]) );
		}
	}

	public IRuntime getRuntime( String type ) {
		return (IRuntime)runtimeMap.get( type );
	}

	public IRuntime[] getRuntimes() {
		return (IRuntime [])runtimeMap.values().toArray( new IRuntime[0] );
	}
	
	public void addRuntime( IRuntime runtime ) {
		if( !runtimeMap.containsKey(runtime.getId()) ){
			runtimeMap.put( runtime.getId(), runtime );
			
			latestRuntimeAdded = runtime;
		}
	}

	public void removeRuntime(IRuntime runtime) {
		runtimeMap.remove( runtime.getId() );
	}

	public IRuntimeInstance[] getRuntimeInstances() {
		ArrayList instanceList = new ArrayList();
		
		IRuntime [] runtimes = getRuntimes();
		for (int i = 0; i < runtimes.length; i++) {
			
			IRuntimeInstance [] instances = runtimes[i].getRuntimeInstances();
			for (int j = 0; j < instances.length; j++) {
				instanceList.add( instances[j] );
			}
		
		}
		
		return (IRuntimeInstance []) instanceList.toArray( new IRuntimeInstance[0] );
	}

	public IRuntimeInstance[] getRuntimeInstancesOfType(IRuntime runtime) {
		return getRuntimeInstancesOfType( runtime.getId() );
	}

	public IRuntimeInstance[] getRuntimeInstancesOfType(String type) {
		if( runtimeMap.containsKey(type) ){
			IRuntime runtime = (IRuntime)runtimeMap.get( type );
			return runtime.getRuntimeInstances();
		}
		
		return new IRuntimeInstance[0];
	}

	public void addRuntimeInstance(IRuntimeInstance instance, String type) {
		RuntimeStandin r = (RuntimeStandin)getRuntime( type );
		r.addInstance( (RuntimeInstanceStandin)instance );
		
	}
	
	public void removeRuntimeInstance(IRuntimeInstance instance) {
		((RuntimeStandin)instance.getType()).removeInstance( (RuntimeInstanceStandin)instance );	
	}
	
	public IRuntime getLatestRuntimeAdded(){
		return latestRuntimeAdded;
	}
	
	/*
	 * Go through all the Standin structure an commit the changes
	 */
	public void commitChanges(){
		
		RuntimeManager manager = RuntimeManager.getInstance();
		
		IRuntime [] rStandins = getRuntimes();
		for (int i = 0; i < rStandins.length; i++) {
			
			RuntimeStandin rStandin = (RuntimeStandin)rStandins[i];
			rStandin.commitChanges();
			
			//add if it is a new one, add it to the manager
			if( rStandin.isNew ){
				manager.addRuntime( rStandin.getRealRuntime() );
			}
			
		}
		
		manager.saveSettings();
	}

}
