package org.eclipse.atf.ui.runtime.standins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.Runtime;
import org.eclipse.atf.runtime.RuntimeInstance;
import org.eclipse.atf.runtime.installer.IRuntimeInstaller;
import org.eclipse.atf.runtime.validator.IRuntimeValidator;
import org.eclipse.atf.runtime.version.IVersionFinder;

public class RuntimeStandin implements IRuntime {

	protected Runtime realRuntime = null;
	
	protected List instanceList = null;
	
	protected List removedList = new ArrayList(); 
	
	protected boolean isNew = false;
	
	//when adding a User defined Runtime
	public RuntimeStandin( String id, String name ){
		this.realRuntime = new Runtime( id, name );
		
		this.realRuntime.setIsUser( true );
		
		this.instanceList = new ArrayList(0);
		
		isNew = true;
	}
	
	
	public RuntimeStandin( Runtime realRuntime ){
		this.realRuntime = realRuntime;
		
		IRuntimeInstance [] realInstances = this.realRuntime.getRuntimeInstances();
		
		instanceList = new ArrayList( realInstances.length );
		
		for (int i = 0; i < realInstances.length; i++) {
			RuntimeInstance instance = (RuntimeInstance) realInstances[i];
			RuntimeInstanceStandin instanceStandin = new RuntimeInstanceStandin(instance, this);
			instanceList.add( instanceStandin );
		}
		
	}
	
	public Runtime getRealRuntime(){
		return realRuntime;
	}
	
	public IRuntimeInstaller getInstaller() {
		return realRuntime.getInstaller();
	}

	public IRuntimeValidator getValidator() {
		return realRuntime.getValidator();
	}
	
	public IVersionFinder getVersionFinder(){
		return realRuntime.getVersionFinder();
	}

	public String getId() {
		return realRuntime.getId();
	}
	
	private String newId = null;
	public void setId( String id ){
		if( isUser() ){
			newId = id;			
		}
	}
	
	public String getName() {
		return realRuntime.getName();
	}
	
	private String newName = null;
	public void setName( String name ){
		if( isUser() ){
			newName = name;			
		}
	}
	
	public boolean isUser() {
		return realRuntime.isUser();
	}

	public IRuntimeInstance[] getRuntimeInstances() {
		return (IRuntimeInstance[])instanceList.toArray( new IRuntimeInstance[0] );
	}
	
	public boolean isAllowUserInstances() {
		return realRuntime.isAllowUserInstances();
	}

	public void addInstance( RuntimeInstanceStandin instance) {
		instanceList.add( instance );
		instance.setType( this );
	}

	public void removeInstance( RuntimeInstanceStandin instance) {
		instanceList.remove( instance );
		
		instance.setType( null );
		
		removedList.add( instance );
		
	}
	
	/**
	 * This method commits all the changes made by the Dialog back into the model
	 */
	public void commitChanges(){
		
		//commit changes to name or id if this is a user defined Runtime
		if( isUser() ){
			
			if( newName != null )
				realRuntime.setName( newName );
			
			if( newId != null )
				realRuntime.setId( newId );
			
		}		
		
		//start by commiting the changed and added instances
		IRuntimeInstance [] instances = getRuntimeInstances();
		for (int i = 0; i < instances.length; i++) {
			
			RuntimeInstanceStandin instanceStandin = (RuntimeInstanceStandin) instances[i];
			
			//pushes changes into the wrapped instance
			instanceStandin.commitChanges();
			
			if( instanceStandin.isNew ){
				realRuntime.addInstance( instanceStandin.getRealInstance() );
			}

		}
		
		//remove deleted instances
		for (Iterator instanceIter = removedList.iterator(); instanceIter.hasNext();) {
			RuntimeInstanceStandin instanceStandin = (RuntimeInstanceStandin) instanceIter.next();
			RuntimeInstance realInstance = instanceStandin.getRealInstance();
			
			if( realInstance != null )
				realRuntime.removeInstance( realInstance );
		}
		
	}
	
	public boolean equals( Object obj )
	{
		if ( obj instanceof RuntimeStandin )
			return super.equals( obj );
		
		return realRuntime.equals( obj );
	}

}
