/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/

package org.eclipse.atf.ui.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SelectionTester extends PropertyTester {

	public SelectionTester() {
		super();
	}
	
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		try {
			if(receiver instanceof IStructuredSelection) {
				IStructuredSelection selection = (IStructuredSelection)receiver;
				Object firstElement = selection.getFirstElement();
				if(firstElement instanceof IFile) {
					IFile file = (IFile)firstElement;
					if(file.getFileExtension().equals("jsp"))
						return true;
				}
			}
		} catch(Exception e) {
			return false;
		}
		return false;
		
	}
	
	

}
