/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.MozideCorePlugin;
import org.mozilla.interfaces.nsISupports;

public class XPCOMThreadProxy
implements InvocationHandler {
    protected nsISupports mozillaObject;
    protected IXPCOMThreadProxyHelper proxyHelper;
    private Object _value;
    private Throwable _throwable;

    protected XPCOMThreadProxy(nsISupports aMozillaObject, IXPCOMThreadProxyHelper aProxyHelper) {
        this.mozillaObject = aMozillaObject;
        this.proxyHelper = aProxyHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, final Method method, Object[] args) throws Throwable {
        Object value = null;
        Throwable throwable = null;
        if (Thread.currentThread() == this.proxyHelper.getThread()) {
            try {
                value = method.invoke((Object)this.mozillaObject, args);
            }
            catch (IllegalAccessException iae) {
                MozideCorePlugin.log(iae);
            }
            catch (InvocationTargetException ite) {
                throwable = ite.getCause();
            }
        } else {
            final Object[] newArgs = XPCOMThreadProxy.deproxify(args);
            XPCOMThreadProxy xPCOMThreadProxy = this;
            synchronized (xPCOMThreadProxy) {
                this._throwable = null;
                this._value = null;
                this.proxyHelper.syncExec(new Runnable(){

                    public void run() {
                        block6: {
                            try {
                                try {
                                    XPCOMThreadProxy.this._value = method.invoke((Object)XPCOMThreadProxy.this.mozillaObject, newArgs);
                                }
                                catch (IllegalAccessException iae) {
                                    MozideCorePlugin.log(iae);
                                }
                                catch (InvocationTargetException ite) {
                                    Throwable t = ite.getCause();
                                    if (t != null) {
                                        throw t;
                                    }
                                }
                            }
                            catch (Throwable t) {
                                XPCOMThreadProxy.this._throwable = t;
                                if (!(t instanceof Error)) break block6;
                                throw (Error)t;
                            }
                        }
                    }
                });
                value = this._value;
                throwable = this._throwable;
            }
        }
        if (throwable != null) {
            throw throwable;
        }
        if (value instanceof nsISupports) {
            value = XPCOMThreadProxy.createProxy((nsISupports)value, this.proxyHelper);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private static Object[] deproxify(Object[] args) {
        if (args == null) {
            return args;
        }
        newArgs = null;
        i = 0;
        while (i < args.length) {
            if (args[i] != null && XPCOMThreadProxy.isXPCOMThreadProxy(args[i])) {
                newArgs = new Object[args.length];
                if (i == 0) break;
                System.arraycopy(args, 0, newArgs, 0, i);
                break;
            }
            ++i;
        }
        if (newArgs != null) ** GOTO lbl21
        return args;
lbl-1000:
        // 1 sources

        {
            if (args[i] != null && XPCOMThreadProxy.isXPCOMThreadProxy(args[i])) {
                proxy = (XPCOMThreadProxy)Proxy.getInvocationHandler(args[i]);
                newArgs[i] = proxy.mozillaObject;
            } else {
                newArgs[i] = args[i];
            }
            ++i;
lbl21:
            // 2 sources

            ** while (i < args.length)
        }
lbl22:
        // 1 sources

        return newArgs;
    }

    public static boolean isXPCOMThreadProxy(Object obj) {
        return Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof XPCOMThreadProxy;
    }

    public static Object createProxy(nsISupports aMozillaObject, IXPCOMThreadProxyHelper aProxyHelper) {
        if (XPCOMThreadProxy.isXPCOMThreadProxy(aMozillaObject)) {
            return aMozillaObject;
        }
        Class<?>[] ifaces = aMozillaObject.getClass().getInterfaces();
        ArrayList newIfaces = new ArrayList(ifaces.length);
        int i = 0;
        while (i < ifaces.length) {
            if (!ifaces[i].getName().endsWith("XPCOMJavaProxyBase")) {
                newIfaces.add(ifaces[i]);
            }
            ++i;
        }
        Class[] newIfacesArray = new Class[newIfaces.size()];
        newIfaces.toArray(newIfacesArray);
        return Proxy.newProxyInstance(aMozillaObject.getClass().getClassLoader(), newIfacesArray, (InvocationHandler)new XPCOMThreadProxy(aMozillaObject, aProxyHelper));
    }
}

