/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import org.eclipse.atf.mozilla.ide.core.MozideCorePlugin;
import org.eclipse.atf.mozilla.ide.source.ILocalSourceLocatorContext;
import org.eclipse.atf.mozilla.ide.source.ILocalSourceLocatorExtension;
import org.eclipse.atf.mozilla.ide.source.LocalSourceLocatorResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class SourceLocatorUtil {
    protected static SourceLocatorUtil instance = null;

    public static SourceLocatorUtil getInstance() {
        if (instance == null) {
            instance = new SourceLocatorUtil();
        }
        return instance;
    }

    protected SourceLocatorUtil() {
    }

    public IStorage getSourceElement(URL sourceURL, String basePathHint, IProject projectHint) {
        IFile source = this.findLocalResource(sourceURL, basePathHint, projectHint);
        if ((source = this.checkCompatibility(sourceURL, basePathHint, projectHint, (IStorage)source)) == null) {
            source = this.findRemoteResource(sourceURL);
        }
        return source;
    }

    private IStorage checkCompatibility(URL sourceURL, String basePathHint, IProject projectHint, IStorage source) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.atf.mozilla.ide.core.resolver");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            try {
                ILocalSourceLocatorExtension ext = (ILocalSourceLocatorExtension)element.createExecutableExtension("class");
                boolean valid = ext.isValid(sourceURL, basePathHint, projectHint, source);
                if (valid) {
                    ILocalSourceLocatorContext context = ext.createContext();
                    LocalSourceLocatorResolver resolver = (LocalSourceLocatorResolver)element.createExecutableExtension("resolver");
                    resolver.setContext(context);
                    source = resolver.resolve();
                }
            }
            catch (CoreException e) {
                MozideCorePlugin.log(e);
            }
            ++i;
        }
        return source;
    }

    public IStorage getSourceElement(URL sourceURL) {
        return this.getSourceElement(sourceURL, null, null);
    }

    private IFile findLocalResource(URL url, String basePathHint, IProject projectHint) {
        URI resURI;
        IProject possibleProject;
        Path pathPortionOfURL;
        String possibleProjectName;
        IPath relativePathToResource;
        Path basePath;
        String decodedString;
        IFile res = null;
        try {
            decodedString = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            decodedString = url.toString();
        }
        Path urlAsPath = new Path(decodedString);
        if (basePathHint != null && !"".equals(basePathHint)) {
            basePath = new Path(basePathHint);
            if (basePath.isPrefixOf((IPath)urlAsPath)) {
                relativePathToResource = this.stripParameters(urlAsPath.removeFirstSegments(basePath.segmentCount()));
                if (projectHint != null) {
                    res = this.getResource(projectHint, relativePathToResource);
                } else {
                    String possibleProjectName2 = basePath.lastSegment();
                    IProject possibleProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(possibleProjectName2);
                    if (possibleProject2 != null && possibleProject2.exists()) {
                        res = this.getResource(possibleProject2, relativePathToResource);
                    }
                }
            }
            if (res != null) {
                return res;
            }
        }
        if (projectHint != null) {
            basePath = new Path(projectHint.getName());
            if (basePath.isPrefixOf((IPath)urlAsPath)) {
                relativePathToResource = urlAsPath.removeFirstSegments(basePath.segmentCount());
                res = this.getResource(projectHint, relativePathToResource);
            }
            if (res != null) {
                return res;
            }
        }
        if ((possibleProjectName = (pathPortionOfURL = new Path(url.getPath())).segment(0)) != null && (possibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(possibleProjectName)) != null && possibleProject.exists()) {
            IPath relativePathToResource2 = pathPortionOfURL.removeFirstSegments(1);
            res = this.getResource(possibleProject, relativePathToResource2);
        }
        URI workspace = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
        try {
            resURI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        URI relative = workspace.relativize(resURI);
        if (!relative.isAbsolute()) {
            Path path = new Path(relative.toString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file.exists()) {
                return file;
            }
        }
        return res;
    }

    protected IFile getResource(IProject project, IPath pathToResource) {
        IFile file = null;
        if (project != null && (file = project.getFile(pathToResource)).exists()) {
            return file;
        }
        if (pathToResource.segmentCount() > 1) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(pathToResource);
        }
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    private IPath stripParameters(IPath urlAsPath) {
        IPath base = urlAsPath.removeLastSegments(1);
        String fileName = urlAsPath.lastSegment();
        if (fileName == null) {
            return urlAsPath;
        }
        int idx = fileName.indexOf(63);
        if (idx != -1) {
            fileName = fileName.substring(0, idx);
        }
        return base.append(fileName);
    }

    private IStorage findRemoteResource(URL url) {
        return new URLStorage(url);
    }

    public InputStream getSourceContent(URL sourceURL, String basePathHint, IProject projectHint) throws CoreException {
        IStorage storage = this.getSourceElement(sourceURL, basePathHint, projectHint);
        return storage.getContents();
    }

    public URLStorage getURLStorage(String location) {
        URLStorage storage = null;
        try {
            URL url = new URL(location);
            storage = new URLStorage(url);
        }
        catch (MalformedURLException malformedURLException) {}
        return storage;
    }

    protected class URLStorage
    extends PlatformObject
    implements IStorage {
        private URL _url;

        public URLStorage(URL url) {
            this._url = url;
        }

        public InputStream getContents() throws CoreException {
            try {
                URLConnection conn = this._url.openConnection();
                conn.connect();
                return new BufferedInputStream(conn.getInputStream());
            }
            catch (MalformedURLException mue) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.core", 4, "Malformed source URL", (Throwable)mue));
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.core", 4, "I/O Exception reading source", (Throwable)ioe));
            }
        }

        public IPath getFullPath() {
            return new Path(this._url.toString());
        }

        public URL getURL() {
            return this._url;
        }

        public String getName() {
            return this._url.toString();
        }

        public boolean isReadOnly() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof URLStorage) {
                return ((URLStorage)((Object)obj)).getURL().equals(this.getURL());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.getURL().hashCode();
        }

        public Object getAdapter(Class adapter) {
            if (URL.class.equals((Object)adapter)) {
                return this.getURL();
            }
            return super.getAdapter(adapter);
        }
    }
}

