/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui;

import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.model.JSBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.atf.mozilla.ide.debug.ui.util.DebuggerSourceDisplayUtil;
import org.eclipse.atf.mozilla.ide.ui.util.SourceDisplayUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class MozillaDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private boolean _showTypes = false;
    protected SourceDisplayUtil sourceDisplayUtil = new DebuggerSourceDisplayUtil();

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        if ("org.eclipse.debug.ui.displayVariableTypeNames".equals(attribute)) {
            this._showTypes = (Boolean)value;
        }
    }

    public Image getImage(Object element) {
        if (element instanceof Breakpoint) {
            Breakpoint breakpoint = (Breakpoint)element;
            element = breakpoint.getMarker();
        }
        if (element instanceof IMarker) {
            IMarker marker = (IMarker)element;
            return DebugUITools.getImage((String)(marker.getAttribute("org.eclipse.debug.core.enabled", true) ? "IMG_OBJS_BREAKPOINT" : "IMG_OBJS_BREAKPOINT_DISABLED"));
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof JSDebugElement) {
            StringBuffer buf = new StringBuffer();
            if (element instanceof IVariable && this._showTypes) {
                try {
                    IVariable variable = (IVariable)element;
                    String type = variable.getReferenceTypeName();
                    if (type != null) {
                        buf.append(type);
                        buf.append(" ");
                    }
                }
                catch (DebugException ex) {
                    MozillaDebugUIPlugin.log(ex);
                }
            }
            buf.append(((JSDebugElement)element).getLabel());
            return buf.toString();
        }
        if (element instanceof IExpression) {
            IExpression expr = (IExpression)element;
            IValue val = expr.getValue();
            StringBuffer buf = new StringBuffer(expr.getExpressionText());
            if (val != null) {
                buf.append('=');
                buf.append(this.getText(val));
            }
            return buf.toString();
        }
        if (element instanceof JSBreakpoint) {
            return ((JSBreakpoint)element).getLabel();
        }
        return super.getText(element);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            String result = value.getValueString();
            listener.detailComputed(value, result);
        }
        catch (DebugException de) {
            MozillaDebugUIPlugin.log(de);
        }
    }

    public IEditorInput getEditorInput(Object element) {
        return this.sourceDisplayUtil.getEditorInput(element);
    }

    public String getEditorId(IEditorInput input, Object element) {
        return this.sourceDisplayUtil.getEditorId(input, element);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

