/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.internal;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class Utils {
    private static ResourceBundle _resourceBundle;
    private static ResourceBundle _helpResourceBundle;
    private static ImageRegistry _imageRegistry;
    private static HashMap _imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String OBJECT = "obj16/";
    private static final String IBMCopyRight = "(C) Copyright IBM Corp. 2002. All rights reserved.";

    static {
        ICON_BASE_URL = null;
    }

    public static String getResourceString(String key) {
        if (_resourceBundle == null) {
            _resourceBundle = Utils.getResourceBundle();
        }
        if (_resourceBundle != null) {
            return _resourceBundle.getString(key);
        }
        return "!" + key + "!";
    }

    public static String getHelpResourceString(String key) {
        if (_helpResourceBundle == null) {
            _helpResourceBundle = Utils.getHelpResourceBundle();
        }
        if (_helpResourceBundle != null) {
            return _helpResourceBundle.getString(key);
        }
        return "!" + key + "!";
    }

    public static String getFormattedString(String key, String arg) {
        String string = Utils.getResourceString(key);
        return MessageFormat.format(string, arg);
    }

    public static String getFormattedString(String key, String[] args) {
        String string = Utils.getResourceString(key);
        return MessageFormat.format(string, args);
    }

    public static ResourceBundle getResourceBundle() {
        return MozillaDebugUIPlugin.getDefault().getResourceBundle();
    }

    public static ResourceBundle getHelpResourceBundle() {
        try {
            return ResourceBundle.getBundle("com.ibm.rct.laszlo.LaszloHelpResources");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return MozillaDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }
}

