/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.internal.variables;

import java.util.ArrayList;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugVariable;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.preference.IPreferenceStore;

public class JSDebugContentProviderFilter {
    private static boolean includeFunctions(IPresentationContext context) {
        IPreferenceStore store = MozillaDebugUIPlugin.getDefault().getPreferenceStore();
        String statics = "showFunctions";
        return store.getBoolean(statics);
    }

    private static boolean includeInternal(IPresentationContext context) {
        IPreferenceStore store = MozillaDebugUIPlugin.getDefault().getPreferenceStore();
        String statics = "showInternals";
        return store.getBoolean(statics);
    }

    public static Object[] filterVariables(Object[] children, IPresentationContext context) {
        boolean inclFunctions = JSDebugContentProviderFilter.includeFunctions(context);
        boolean inclInternal = JSDebugContentProviderFilter.includeInternal(context);
        if (inclFunctions && inclInternal) {
            return children;
        }
        ArrayList<JSDebugVariable> result = new ArrayList<JSDebugVariable>();
        int i = 0;
        while (i < children.length) {
            Object element = children[i];
            if (element instanceof JSDebugVariable) {
                JSDebugVariable variable = (JSDebugVariable)element;
                try {
                    IValue value = variable.getValue();
                    String referenceTypeName = value.getReferenceTypeName();
                    if (!(!inclFunctions && "function".equals(referenceTypeName) || !inclInternal && variable.isInternal())) {
                        result.add(variable);
                    }
                }
                catch (DebugException debugException) {}
            }
            ++i;
        }
        return result.toArray();
    }
}

