/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.ui.debug;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.ui.debug.MozillaLaunchJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class WebLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected String appPath;
    protected String projectName;
    protected IProject project;
    protected String applicationName;
    protected String moduleName;
    protected boolean isUrl;
    protected ILaunch launch;
    protected String serverMode = "run";
    protected String mode = "run";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.mode = mode;
        int work = 100;
        monitor.beginTask("Launching web application", work);
        if (mode.equals("debug")) {
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (targets[i].getModelIdentifier().equals("org.eclipse.atf.mozilla.ide.debug") && !targets[i].isTerminated()) {
                    String errorMessage = "Multiple JavaScript Debug Sessions is not supported. Terminate the active session before starting a new session.";
                    Status status = new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 4, errorMessage, null);
                    throw new CoreException((IStatus)status);
                }
                ++i;
            }
        }
        this.appPath = configuration.getAttribute("org.eclipse.atf.config.appPath", null);
        this.applicationName = configuration.getAttribute("org.eclipse.atf.ui.debug.processType", null);
        this.isUrl = configuration.getAttribute("org.eclipse.atf.config.isurl", false);
        this.launchApp();
        monitor.worked(work / 2);
        monitor.done();
    }

    private void launchApp() throws CoreException {
        URL url = null;
        if (this.isUrl) {
            try {
                url = new URL(this.appPath);
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Unable to parse URL:" + this.appPath, (Throwable)e));
            }
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.appPath));
        if (!file.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "File doesn't exists in workspace: " + this.appPath, null));
        }
        try {
            url = file.getLocationURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Malformed URL:" + file.getLocationURI(), (Throwable)e));
        }
        MozillaLaunchJob mozillaJob = new MozillaLaunchJob(this.applicationName, this.launch, url);
        mozillaJob.schedule();
    }

    private void showError(String title, String message, Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", message, (Throwable)e));
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            window = windows[0];
        }
        return window;
    }
}

