/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.ui.debug;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.atf.ui.debug.ApplicationFileSelectionDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WebLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected Text pathField;
    protected Label appLabel;
    protected Label browserLabel;
    protected String applicationType = "Mozilla";
    protected String[] requiredNatures = new String[0];
    private String appPath = "";
    private Button appButton;
    private Button urlTypeButton;
    private Button fileTypeButton;
    protected boolean isURL;
    private String filePath = "";
    private String urlPath = "";

    public WebLaunchConfigurationTab(String applicationType, String[] requiredNatures, String mode) {
        this.applicationType = applicationType;
        this.requiredNatures = requiredNatures;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public void createControl(Composite parent) {
        Composite tab = new Composite(parent, 0);
        tab.setFont(parent.getFont());
        tab.setLayout((Layout)new GridLayout());
        tab.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)tab);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData data = new GridData(768);
        Group webGroup = new Group(tab, 0);
        webGroup.setFont(parent.getFont());
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        webGroup.setLayout((Layout)gridLayout);
        webGroup.setLayoutData((Object)new GridData(768));
        webGroup.setText("Debug Target:");
        Composite radioGroup = new Composite((Composite)webGroup, 0);
        radioGroup.setLayout((Layout)new RowLayout());
        this.fileTypeButton = new Button(radioGroup, 16);
        this.fileTypeButton.setFont(parent.getFont());
        this.fileTypeButton.setText("Project file");
        this.urlTypeButton = new Button(radioGroup, 16);
        this.urlTypeButton.setFont(parent.getFont());
        this.urlTypeButton.setText("URL");
        this.urlTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (WebLaunchConfigurationTab.this.urlTypeButton.getSelection() && !WebLaunchConfigurationTab.this.isURL) {
                    WebLaunchConfigurationTab.this.isURL = true;
                    WebLaunchConfigurationTab.this.appButton.setVisible(false);
                    WebLaunchConfigurationTab.this.filePath = WebLaunchConfigurationTab.this.pathField.getText();
                    if (WebLaunchConfigurationTab.this.urlPath != null) {
                        WebLaunchConfigurationTab.this.pathField.setText(WebLaunchConfigurationTab.this.urlPath);
                    }
                }
                WebLaunchConfigurationTab.this.updateWidgetEnablements();
                WebLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fileTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (WebLaunchConfigurationTab.this.fileTypeButton.getSelection() && WebLaunchConfigurationTab.this.isURL) {
                    WebLaunchConfigurationTab.this.isURL = false;
                    WebLaunchConfigurationTab.this.appButton.setVisible(true);
                    WebLaunchConfigurationTab.this.urlPath = WebLaunchConfigurationTab.this.pathField.getText();
                    if (WebLaunchConfigurationTab.this.filePath != null) {
                        WebLaunchConfigurationTab.this.pathField.setText(WebLaunchConfigurationTab.this.filePath);
                    }
                }
                WebLaunchConfigurationTab.this.updateWidgetEnablements();
                WebLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite temp = new Composite((Composite)webGroup, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        temp.setLayout((Layout)gridLayout);
        temp.setLayoutData((Object)new GridData(768));
        this.pathField = new Text(temp, 2052);
        data = new GridData(768);
        this.pathField.setLayoutData((Object)data);
        this.pathField.setFont(parent.getFont());
        this.pathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                WebLaunchConfigurationTab.this.appPath = WebLaunchConfigurationTab.this.pathField.getText();
                WebLaunchConfigurationTab.this.updateWidgetEnablements();
                WebLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.appButton = this.createPushButton(temp, "Browse...", null);
        this.appButton.setVisible(!this.isURL);
        this.appButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WebLaunchConfigurationTab.this.handleAppButtonSelected();
                WebLaunchConfigurationTab.this.updateWidgetEnablements();
            }
        });
        Composite serverOptionGroup = new Composite((Composite)webGroup, 0);
        serverOptionGroup.setLayout((Layout)new RowLayout());
    }

    protected void updateWidgetEnablements() {
        this.appButton.setEnabled(true);
        this.setErrorMessage(null);
        if (this.isURL) {
            if (this.pathField.getText().equals("")) {
                this.setErrorMessage("A valid URL must be specified");
            } else {
                try {
                    new URL(this.pathField.getText());
                }
                catch (MalformedURLException e) {
                    this.setErrorMessage(e.getMessage());
                }
            }
        } else if (this.pathField.getText().equals("") || !this.isValidPath(this.pathField.getText())) {
            this.setErrorMessage("A valid workspace file must be specified");
        }
    }

    protected void handleAppButtonSelected() {
        Object[] targetFiles;
        IFile targetFile;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ApplicationFileSelectionDialog dialog = new ApplicationFileSelectionDialog(this.getShell(), (ILabelProvider)new WebLaunchLabelProvider(), "Web application file selection", "Select a target web application file from the project's contents", projects, this.requiredNatures, false);
        dialog.setInput(projects);
        dialog.setAllowMultiple(false);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (targetFile = (IFile)(targetFiles = dialog.getResult())[0]) != null) {
            this.pathField.setText(targetFile.getFullPath().toPortableString());
            this.updateLaunchConfigurationDialog();
        }
    }

    protected IPath computeDefaultDirectory(IPath projectPath) {
        return projectPath;
    }

    protected boolean isValidProject(String projName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project.exists();
    }

    protected boolean isValidPath(String path) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.isURL = false;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.isURL = config.getAttribute("org.eclipse.atf.config.isurl", false);
            this.urlTypeButton.setSelection(this.isURL);
            config.getAttribute("org.eclipse.atf.config.project", "");
            this.appPath = config.getAttribute("org.eclipse.atf.config.appPath", "");
            if (this.isURL) {
                this.pathField.setText(this.appPath);
            } else if (!config.getAttribute("org.eclipse.atf.ui.config.fullPath", "").equals("")) {
                this.pathField.setText(config.getAttribute("org.eclipse.atf.ui.config.fullPath", ""));
            } else {
                this.pathField.setText(this.appPath);
            }
            this.fileTypeButton.setSelection(!this.isURL);
            this.appButton.setVisible(!this.isURL);
            this.updateWidgetEnablements();
        }
        catch (CoreException ce) {
            MozillaDebugUIPlugin.getDefault().getLog().log(ce.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        Path path = new Path(this.pathField.getText());
        if (this.isURL) {
            config.setAttribute("org.eclipse.atf.config.appPath", this.appPath);
        } else {
            String projectName = path.segment(0);
            config.setAttribute("org.eclipse.atf.config.project", projectName);
            config.setAttribute("org.eclipse.atf.config.appPath", this.appPath);
        }
        config.setAttribute("org.eclipse.atf.ui.debug.processType", this.getName());
        config.setAttribute("org.eclipse.atf.config.isurl", this.urlTypeButton.getSelection());
        config.setAttribute("org.eclipse.atf.ui.config.fullPath", this.pathField.getText());
    }

    public String getName() {
        return "Configuration";
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }

    private class WebLaunchLabelProvider
    extends WorkbenchLabelProvider {
        private WebLaunchLabelProvider() {
        }

        protected String decorateText(String input, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                String filename = file.getName();
                return filename;
            }
            return input;
        }
    }
}

