/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.ui.debug;

import java.net.URL;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class WebLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getWebLaunchConfigType());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            this.searchAndLaunch(new Object[]{file}, mode, this.getWebLaunchConfigType());
        }
    }

    protected ILaunchConfigurationType getWebLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.atf.ui.debug.webApplication");
    }

    public void searchAndLaunch(Object[] search, String mode, ILaunchConfigurationType configType) {
        IFile file = null;
        int entries = search == null ? 0 : search.length;
        int i = 0;
        while (i < entries) {
            block9: {
                try {
                    String appPathString = null;
                    IProject project = null;
                    Object obj = search[i];
                    boolean isURL = false;
                    if (obj instanceof IFile) {
                        file = (IFile)obj;
                        project = file.getProject();
                        appPathString = file.getFullPath().toPortableString();
                        isURL = false;
                    } else if (obj instanceof URL) {
                        URL u = (URL)obj;
                        appPathString = u.toExternalForm();
                        isURL = true;
                    } else {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Selection must be a valid application file", null));
                    }
                    if (appPathString == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Could not find launch target for selection", null));
                    }
                    String moduleName = "";
                    ILaunchConfiguration config = this.findLaunchConfiguration(project.getName(), moduleName, appPathString, isURL, mode, configType);
                    if (config != null) {
                        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                        break block9;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Could not find corresponding launch configuration", null));
                }
                catch (CoreException ce) {
                    final IStatus stat = ce.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"An unexpected error has occurred", (String)"Error launching web application", (IStatus)stat);
                        }
                    });
                }
            }
            ++i;
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(String project, String module, String appPathString, boolean isURL, String mode, ILaunchConfigurationType configType) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int numConfigs = configs == null ? 0 : configs.length;
            int i = 0;
            while (i < numConfigs) {
                String cPathString = configs[i].getAttribute("org.eclipse.atf.config.appPath", null);
                String cProject = configs[i].getAttribute("org.eclipse.atf.config.project", null);
                String cBrowserExec = configs[i].getAttribute("org.eclipse.atf.ui.debug.browserexec", null);
                boolean cIsURL = configs[i].getAttribute("org.eclipse.atf.config.isurl", false);
                if (!cIsURL) {
                    if (appPathString.equals(cPathString) && configs[i].supportsMode(mode) && project.equals(cProject) && cBrowserExec != null) {
                        config = configs[i].getWorkingCopy();
                        break;
                    }
                } else if (appPathString.equals(cPathString) && configs[i].supportsMode(mode) && cIsURL == isURL) {
                    config = configs[i].getWorkingCopy();
                    break;
                }
                ++i;
            }
            if (config == null) {
                config = this.createConfiguration(project, module, appPathString, isURL, configType);
            }
        }
        catch (CoreException ce) {
            MozillaDebugUIPlugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfiguration createConfiguration(String project, String module, String appPathString, boolean isURL, ILaunchConfigurationType configType) throws CoreException {
        ILaunchConfiguration config = null;
        String browserLocation = "";
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(String.valueOf(module) + "-" + new Path(appPathString).lastSegment()));
        wc.setAttribute("org.eclipse.atf.config.project", project);
        wc.setAttribute("org.eclipse.atf.ui.debug.processType", "Mozilla");
        wc.setAttribute("org.eclipse.atf.config.isurl", isURL);
        wc.setAttribute("org.eclipse.atf.config.appPath", appPathString);
        wc.setAttribute("org.eclipse.atf.ui.debug.browserexec", browserLocation);
        wc.setAttribute("org.eclipse.atf.config.isinternalbrowser", true);
        wc.setAttribute("org.eclipse.atf.ui.config.fullPath", "");
        config = wc.doSave();
        return config;
    }
}

