/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.extras.actions;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.nsIDOMComment;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PasteNodeAction
extends DOMSelectionAction {
    private nsIDOMDocument domDoc = null;
    private Clipboard clipboard;

    public void run() {
        if (this.getSelection() != null && !this.getSelection().isEmpty()) {
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    this.clipboard = new Clipboard(Display.getCurrent());
                    String nodeString = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (nodeString != null) {
                        nsIDOMNode node = this.getSelection().getSelectedNode();
                        Document xmlDoc = builder.parse(new InputSource(new StringReader(nodeString)));
                        Node top = xmlDoc.getFirstChild();
                        this.domDoc = node.getOwnerDocument();
                        nsIDOMElement domTop = this.domDoc.createElement(top.getNodeName());
                        NodeList subs = top.getChildNodes();
                        NamedNodeMap attrs = top.getAttributes();
                        int h = 0;
                        while (h < attrs.getLength()) {
                            domTop.setAttribute(attrs.item(h).getNodeName(), attrs.item(h).getNodeValue());
                            ++h;
                        }
                        domTop.setNodeValue(top.getNodeValue());
                        int i = 0;
                        while (i < subs.getLength()) {
                            this.parse(subs.item(i), (nsIDOMNode)domTop);
                            ++i;
                        }
                        node.appendChild((nsIDOMNode)domTop);
                    }
                }
                catch (Exception exception) {
                    if (this.clipboard != null) {
                        this.clipboard.dispose();
                    }
                }
            }
            finally {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
            }
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        super.menuAboutToShow(manager);
        if (this.isEnabled()) {
            try {
                try {
                    this.clipboard = new Clipboard(Display.getCurrent());
                    String nodeString = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setErrorHandler(new ErrorHandler(){

                        public void warning(SAXParseException exception) throws SAXException {
                        }

                        public void fatalError(SAXParseException exception) throws SAXException {
                        }

                        public void error(SAXParseException exception) throws SAXException {
                        }
                    });
                    builder.parse(new InputSource(new StringReader(nodeString)));
                }
                catch (Exception exception) {
                    this.setEnabled(false);
                    if (this.clipboard != null) {
                        this.clipboard.dispose();
                    }
                }
            }
            finally {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
            }
        }
    }

    private void parse(Node node, nsIDOMNode domNode) {
        if (node.getNodeName().equals("#text")) {
            String testEmpty = node.getNodeValue().replace('\n', ' ');
            testEmpty = testEmpty.replace('\t', ' ');
            testEmpty = testEmpty.trim();
            nsIDOMText text = this.domDoc.createTextNode(node.getNodeValue());
            domNode.appendChild((nsIDOMNode)text);
        } else if (node.getNodeName().equals("#comment")) {
            nsIDOMComment comment = this.domDoc.createComment(node.getNodeValue());
            domNode.appendChild((nsIDOMNode)comment);
        } else {
            nsIDOMElement el = this.domDoc.createElement(node.getNodeName());
            domNode.appendChild((nsIDOMNode)el);
            el.setNodeValue(node.getNodeValue());
            NodeList subNodes = node.getChildNodes();
            NamedNodeMap attrs = node.getAttributes();
            int h = 0;
            while (h < attrs.getLength()) {
                el.setAttribute(attrs.item(h).getNodeName(), attrs.item(h).getNodeValue());
                ++h;
            }
            int i = 0;
            while (i < subNodes.getLength()) {
                this.parse(subNodes.item(i), (nsIDOMNode)el);
                ++i;
            }
        }
    }
}

