/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.ui.browser.PopupWindowBrowserListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MozBrowserDialog
extends Dialog {
    protected Browser browser = null;

    protected MozBrowserDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x870 | MozBrowserDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.browser = new Browser(parent, 32768);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.initialize(this.browser);
        return this.browser;
    }

    private void initialize(Browser browser) {
        browser.addOpenWindowListener((OpenWindowListener)new PopupWindowBrowserListener(new IShellProvider(){

            public Shell getShell() {
                return MozBrowserDialog.this.getShell();
            }
        }));
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (event.title != null && event.title.length() > 0) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.setText(event.title);
                }
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public Browser getMozillaBrowser() {
        return this.browser;
    }
}

