/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.console;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsIScriptError;

public class ConsoleMessageLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected static final int IMAGE_COLUMN_INDEX = 0;
    protected static final int CATEGORY_COLUMN_INDEX = 1;
    protected static final int MSG_COLUMN_INDEX = 1;
    protected static final int SRCNAME_COLUMN_INDEX = 2;
    protected static final int LINENUM_COLUMN_INDEX = 3;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof String) {
                return this.getInfoImage();
            }
            nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
            try {
                nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
                if (scriptError.getFlags() == 0L) {
                    return this.getErrorImage();
                }
                if (scriptError.getFlags() == 1L) {
                    return this.getWarningImage();
                }
                if (scriptError.getFlags() == 2L) {
                    return this.getExceptionImage();
                }
            }
            catch (Exception exception) {}
            return this.getInfoImage();
        }
        if (columnIndex == 1 && element instanceof nsIConsoleMessage) {
            nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
            try {
                nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
                String category = scriptError.getCategory();
                if (category.indexOf("CSS") != -1) {
                    return this.getCSSImage();
                }
                if (category.indexOf("javascript") != -1) {
                    return this.getJSImage();
                }
                if (category.indexOf("XML") != -1 || category.indexOf("malformed-xml") != -1) {
                    return this.getXMLImage();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        if (columnIndex == 1) {
            return this.getMessage(element);
        }
        if (columnIndex == 2) {
            return ConsoleMessageLabelProvider.getSourceName(element);
        }
        if (columnIndex == 3) {
            int line = ConsoleMessageLabelProvider.getLineNum(element);
            return line == -1 ? "" : Integer.toString(line);
        }
        return null;
    }

    public static int getLineNum(Object element) {
        if (!(element instanceof nsIConsoleMessage)) {
            return -1;
        }
        nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
        try {
            String error;
            String location;
            nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
            String line = scriptError.getSourceLine();
            if ("".equals(line) && (location = ConsoleMessageLabelProvider.getQuotedStringAfter("location:", error = scriptError.getErrorMessage())) != null) {
                int lineOffset = location.indexOf("Line:");
                String linePart = location.substring(lineOffset + "Line:".length()).trim();
                try {
                    return Integer.parseInt(linePart);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return (int)scriptError.getLineNumber();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static String getQuotedStringAfter(String string, String text) {
        int offset = text.indexOf(string);
        if (offset == -1) {
            return null;
        }
        int startQuote = text.indexOf(34, offset);
        if (startQuote == -1) {
            return null;
        }
        int endQuote = text.indexOf(34, startQuote + 1);
        return text.substring(startQuote + 1, endQuote);
    }

    public static String getSourceName(Object element) {
        if (!(element instanceof nsIConsoleMessage)) {
            return null;
        }
        nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
        try {
            String error;
            String location;
            nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
            String sourceName = scriptError.getSourceName();
            if ("".equals(sourceName) && (location = ConsoleMessageLabelProvider.getQuotedStringAfter("location:", error = scriptError.getErrorMessage())) != null) {
                int urlEnd = location.indexOf(32);
                String url = urlEnd == -1 ? location : location.substring(0, urlEnd);
                try {
                    new URL(url);
                    return url;
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return sourceName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getMessage(Object element) {
        if (element instanceof String) {
            return element.toString();
        }
        if (!(element instanceof nsIConsoleMessage)) {
            return null;
        }
        nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
        try {
            nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
            String message = scriptError.getErrorMessage();
            return message;
        }
        catch (Exception exception) {
            return consoleMessage.getMessage();
        }
    }

    protected Image getCSSImage() {
        return MozIDEUIPlugin.getDefault().getImage("CSSFILTER_ID");
    }

    protected Image getJSImage() {
        return MozIDEUIPlugin.getDefault().getImage("JSFILTER_ID");
    }

    protected Image getXMLImage() {
        return MozIDEUIPlugin.getDefault().getImage("HTMLFILTER_ID");
    }

    protected Image getInfoImage() {
        return MozIDEUIPlugin.getDefault().getImage("INFO_IMG_ID");
    }

    protected Image getErrorImage() {
        return MozIDEUIPlugin.getDefault().getImage("ERROR_IMG_ID");
    }

    protected Image getWarningImage() {
        return MozIDEUIPlugin.getDefault().getImage("WARNING_IMG_ID");
    }

    protected Image getExceptionImage() {
        return MozIDEUIPlugin.getDefault().getImage("EXCEPTION_IMG_ID");
    }
}

