/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.mozilla.interfaces.inIDOMUtils;
import org.mozilla.interfaces.nsIDOMCSSRule;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMCSSStyleRule;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupportsArray;
import org.mozilla.xpcom.Mozilla;

public class CSSContentProvider
implements ITreeContentProvider {
    protected nsIDOMNode currentNode;
    protected Map nodeMap = new TreeMap();
    protected Map parentMap = new HashMap();
    protected Map propertiesToRules = new HashMap();
    protected Map definedProperties = new HashMap();
    protected static final String INLINE_STYLE = "Inline_Styles";
    protected static final String PROPERTY_ADDED = "(**Property Added)";

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof nsIDOMNode) {
            return this.nodeMap.keySet().toArray();
        }
        if (this.nodeMap.containsKey(parentElement)) {
            return ((List)this.nodeMap.get(parentElement)).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        Object retVal = null;
        if (element instanceof Map) {
            return this.parentMap.get(element);
        }
        return retVal;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CSSProperty && ((CSSProperty)element).getName().equals("") && ((CSSProperty)element).getValue().equals("")) {
            return this.nodeMap.containsKey(element);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.currentNode);
    }

    public void dispose() {
    }

    protected void parseNodes() {
        StringTokenizer token;
        this.nodeMap.clear();
        this.propertiesToRules.clear();
        this.parentMap.clear();
        this.definedProperties.clear();
        nsIDOMNode node = this.currentNode;
        nsIDOMElement domElement = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        try {
            inIDOMUtils service = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
            nsISupportsArray rules = service.getCSSStyleRules(domElement);
            long numRules = rules.count();
            long i = 0L;
            while (i < numRules) {
                nsIDOMCSSRule ret = (nsIDOMCSSRule)rules.getElementAt(i).queryInterface("{a6cf90c1-15b3-11d2-932e-00805f8add32}");
                nsIDOMCSSStyleRule styleRule = (nsIDOMCSSStyleRule)ret.queryInterface("{a6cf90bf-15b3-11d2-932e-00805f8add32}");
                nsIDOMCSSStyleDeclaration styleDec = styleRule.getStyle();
                String lineNumber = Long.toString(service.getRuleLine(styleRule));
                String url = styleRule.getParentStyleSheet().getHref();
                ArrayList<CSSProperty> properties = new ArrayList<CSSProperty>();
                long j = 0L;
                while (j < styleDec.getLength()) {
                    String name = styleDec.item(j);
                    String value = styleDec.getPropertyValue(name);
                    CSSProperty cssProperty = new CSSProperty(name, value, url, lineNumber, styleRule.getSelectorText());
                    properties.add(cssProperty);
                    if (this.definedProperties.containsKey(name)) {
                        CSSProperty tempProp = (CSSProperty)this.definedProperties.get(name);
                        tempProp.setPresent(false);
                    }
                    cssProperty.setPresent(true);
                    cssProperty.setProperty(true);
                    this.definedProperties.put(name, cssProperty);
                    ++j;
                }
                CSSProperty ruleProperty = new CSSProperty("", "", url, lineNumber, styleRule.getSelectorText());
                ruleProperty.setProperty(false);
                this.propertiesToRules.put(ruleProperty.getHash(), styleDec);
                this.nodeMap.put(ruleProperty, properties);
                this.parentMap.put(properties, rules);
                ++i;
            }
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
        }
        String inlineStyle = domElement.getAttribute("style");
        if (inlineStyle != null && !inlineStyle.equals("") && (token = new StringTokenizer(inlineStyle, ";")).hasMoreTokens()) {
            CSSProperty inlineRuleProperty = new CSSProperty("", "", "", "", INLINE_STYLE);
            inlineRuleProperty.setProperty(false);
            inlineRuleProperty.setInline(true);
            ArrayList<CSSProperty> inlineProperties = new ArrayList<CSSProperty>();
            while (token.hasMoreTokens()) {
                String cssDec = token.nextToken();
                if (cssDec.indexOf(58) == -1) continue;
                String name = cssDec.substring(0, cssDec.indexOf(58));
                name = name.trim();
                String value = cssDec.substring(cssDec.indexOf(58) + 1, cssDec.length());
                value = value.trim();
                CSSProperty inlineProperty = new CSSProperty(name, value, "", "", INLINE_STYLE);
                if (this.definedProperties.containsKey(name)) {
                    CSSProperty tempProp = (CSSProperty)this.definedProperties.get(name);
                    tempProp.setPresent(false);
                }
                inlineProperty.setInline(true);
                inlineProperty.setPresent(true);
                inlineProperty.setProperty(true);
                this.definedProperties.put(name, inlineProperty);
                inlineProperties.add(inlineProperty);
            }
            this.nodeMap.put(inlineRuleProperty, inlineProperties);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput instanceof nsIDOMNode) {
            this.currentNode = (nsIDOMNode)newInput;
            this.parseNodes();
        }
    }
}

