/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class CSSLabelProvider
implements ITableLabelProvider {
    public static final String[] COLUMNS = new String[]{"Rule", "Property", "Value", "URL", "Line Number"};
    private Device device;
    private Map colors = new HashMap();

    public CSSLabelProvider(Device device) {
        this.device = device;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof CSSProperty && columnIndex == 2) {
            CSSProperty property;
            RGB color;
            if (((CSSProperty)element).isColor() && (color = (property = (CSSProperty)element).getRGBValue()) != null) {
                return this.getImage(color, 50, 10);
            }
        } else if (element instanceof CSSProperty && columnIndex == 1 && !((CSSProperty)element).getName().equals("")) {
            if (((CSSProperty)element).isPresent()) {
                return this.getImage(new RGB(0, 200, 0), 10, 10);
            }
            return this.getImage(new RGB(200, 0, 0), 10, 10);
        }
        return null;
    }

    private Image getImage(RGB color, int width, int height) {
        Image img = (Image)this.colors.get(color);
        if (img == null) {
            PaletteData pd = new PaletteData(new RGB[]{color});
            ImageData id = new ImageData(width, height, 1, pd);
            img = new Image(this.device, id);
            this.colors.put(color, img);
        }
        return img;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof CSSProperty) {
            CSSProperty property = (CSSProperty)element;
            if (columnIndex == 0) {
                if (property.isProperty()) {
                    return "";
                }
                if (property.isRule()) {
                    return property.getRule();
                }
            } else if (columnIndex == 1) {
                return property.getName();
            }
            if (columnIndex == 2) {
                if (property.isColor()) {
                    return property.getValue();
                }
                return property.getValue();
            }
            if (columnIndex == 3 && (property.isRule() || property.isComputed())) {
                return property.getURL();
            }
            if (columnIndex == 4) {
                if (property.isRule() || property.isComputed()) {
                    return property.getLineNumber();
                }
                return "";
            }
        }
        return "";
    }

    public void dispose() {
        for (Image img : this.colors.values()) {
            if (img.isDisposed()) continue;
            img.dispose();
        }
        this.colors.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void addListener(ILabelProviderListener listener) {
    }
}

