/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.atf.mozilla.ide.ui.css.StyleRulesContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public class CSSPropertyEditingSupport
extends EditingSupport {
    private TextCellEditor textEditor;
    private ColorCellEditor colorEditor;
    private StyleRulesContentProvider ruleViewerContentProvider;

    public CSSPropertyEditingSupport(TreeViewer viewer, StyleRulesContentProvider ruleViewerContentProvider) {
        super((ColumnViewer)viewer);
        this.textEditor = new TextCellEditor((Composite)viewer.getTree());
        this.colorEditor = new ColorCellEditor((Composite)viewer.getTree());
        this.ruleViewerContentProvider = ruleViewerContentProvider;
    }

    protected boolean canEdit(Object element) {
        if (!(element instanceof CSSProperty)) {
            return false;
        }
        CSSProperty cssprop = (CSSProperty)element;
        return !cssprop.isRule() && !cssprop.getURL().startsWith("resource");
    }

    protected CellEditor getCellEditor(Object element) {
        CSSProperty cssprop = (CSSProperty)element;
        if (cssprop.isColor()) {
            return this.colorEditor;
        }
        return this.textEditor;
    }

    protected Object getValue(Object element) {
        CSSProperty cssprop = (CSSProperty)element;
        if (cssprop.isColor()) {
            return cssprop.getRGBValue();
        }
        return cssprop.getValue();
    }

    protected void setValue(Object element, Object value) {
        RGB newColor;
        RGB old;
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (!(element instanceof CSSProperty)) {
            return;
        }
        CSSProperty cssprop = (CSSProperty)element;
        if (value instanceof RGB && !(old = cssprop.getRGBValue()).equals((Object)(newColor = (RGB)value))) {
            cssprop.setRGBValue(newColor);
            this.ruleViewerContentProvider.updateProperty(cssprop);
            this.getViewer().refresh((Object)cssprop);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (!cssprop.getValue().equals(value)) {
                cssprop.setValue(str);
                this.ruleViewerContentProvider.updateProperty(cssprop);
                this.getViewer().refresh((Object)cssprop);
            }
        }
    }
}

