/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.inspector;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.DOMAttributeAddDialog;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.DOMAttributeEditDialog;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.DOMAttributeProperty;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.IDOMInspectorProperty;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.xpcom.XPCOMException;

public class DOMAttributeViewer
extends TableViewer {
    protected static final String[] attributesColumns = new String[]{"Attribute", "Value"};
    protected Menu contextMenu = null;
    protected boolean initialResize = true;

    public DOMAttributeViewer(Composite parent, int style) {
        super(parent, style);
        this.setupTable();
        this.setupProviders();
        this.setupEdit();
        this.setupMenu();
    }

    protected void setupTable() {
        Table table = this.getTable();
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(attributesColumns[0]);
        tc = new TableColumn(table, 16384);
        tc.setText(attributesColumns[1]);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DOMAttributeViewer.this.handleResize(e);
            }
        });
    }

    protected void setupProviders() {
        this.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((IDOMInspectorProperty)element).getDisplayName();
                }
                if (columnIndex == 1) {
                    nsIDOMNode node = (nsIDOMNode)DOMAttributeViewer.this.getInput();
                    return ((IDOMInspectorProperty)element).getValue(node);
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (((nsIDOMNode)inputElement).getNodeType() == 1) {
                    try {
                        nsIDOMNode node = (nsIDOMNode)inputElement;
                        nsIDOMElement element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                        nsIDOMNamedNodeMap attrMap = element.getAttributes();
                        Object[] properties = new IDOMInspectorProperty[(int)attrMap.getLength()];
                        int i = 0;
                        while (i < (int)attrMap.getLength()) {
                            nsIDOMNode attr = attrMap.item((long)i);
                            properties[i] = new DOMAttributeProperty(attr.getNodeName(), attr.getNodeName());
                            ++i;
                        }
                        return properties;
                    }
                    catch (Exception e) {
                        MozIDEUIPlugin.log(e);
                        return new Object[0];
                    }
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    protected void setupEdit() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[table.getColumnCount()];
        TextCellEditor valueEditor = new TextCellEditor((Composite)table);
        editors[1] = valueEditor;
        this.setCellEditors(editors);
        this.setColumnProperties(attributesColumns);
        this.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property == attributesColumns[1] && element instanceof DOMAttributeProperty;
            }

            public Object getValue(Object element, String property) {
                DOMAttributeProperty attrProperty = (DOMAttributeProperty)element;
                return attrProperty.getValue((nsIDOMNode)DOMAttributeViewer.this.getInput());
            }

            public void modify(Object element, String property, Object value) {
                TableItem item;
                if (element instanceof TableItem && !(item = (TableItem)element).getText().equals(value)) {
                    DOMAttributeProperty attrProperty = (DOMAttributeProperty)item.getData();
                    attrProperty.setValue((nsIDOMNode)DOMAttributeViewer.this.getInput(), (String)value);
                    DOMAttributeViewer.this.refresh();
                }
            }
        });
    }

    protected void setupMenu() {
        this.contextMenu = new Menu(this.getControl());
        MenuItem addItem = new MenuItem(this.contextMenu, 8);
        addItem.setText("Add");
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object inputNode;
                DOMAttributeAddDialog dialog = new DOMAttributeAddDialog(DOMAttributeViewer.this.getControl().getShell());
                int rc = dialog.open();
                if (rc != 0) {
                    return;
                }
                String attributeName = dialog.getAttributeName();
                String attributeValue = dialog.getAttributeValue();
                if (attributeName != null && attributeValue != null && !"".equals(attributeName) && !"".equals(attributeValue) && (inputNode = DOMAttributeViewer.this.getInput()) instanceof nsIDOMNode && ((nsIDOMNode)inputNode).getNodeType() == 1) {
                    try {
                        nsIDOMElement inputElement = (nsIDOMElement)((nsIDOMNode)inputNode).queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                        inputElement.setAttribute(attributeName, attributeValue);
                    }
                    catch (XPCOMException xpcome) {
                        MozIDEUIPlugin.log(xpcome);
                    }
                }
            }
        });
        MenuItem removeItem = new MenuItem(this.contextMenu, 8);
        removeItem.setText("Remove");
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection attributeTableSelection;
                Object selectedObject;
                Object inputNode = DOMAttributeViewer.this.getInput();
                if (inputNode instanceof nsIDOMNode && ((nsIDOMNode)inputNode).getNodeType() == 1 && (selectedObject = (attributeTableSelection = (IStructuredSelection)DOMAttributeViewer.this.getSelection()).getFirstElement()) != null) {
                    DOMAttributeProperty attrProp = (DOMAttributeProperty)selectedObject;
                    try {
                        nsIDOMElement inputElement = (nsIDOMElement)((nsIDOMNode)inputNode).queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                        inputElement.removeAttribute(attrProp.getName());
                    }
                    catch (XPCOMException xpcome) {
                        MozIDEUIPlugin.log(xpcome);
                    }
                }
            }
        });
        MenuItem editItem = new MenuItem(this.contextMenu, 8);
        editItem.setText("Edit");
        editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object inputNode = DOMAttributeViewer.this.getInput();
                if (inputNode instanceof nsIDOMNode && ((nsIDOMNode)inputNode).getNodeType() == 1) {
                    nsIDOMNode inputDOMNode = (nsIDOMNode)inputNode;
                    IStructuredSelection attributeTableSelection = (IStructuredSelection)DOMAttributeViewer.this.getSelection();
                    Object selectedObject = attributeTableSelection.getFirstElement();
                    if (selectedObject != null) {
                        DOMAttributeProperty attrProp = (DOMAttributeProperty)selectedObject;
                        DOMAttributeEditDialog dialog = new DOMAttributeEditDialog(DOMAttributeViewer.this.getControl().getShell(), attrProp.getName(), attrProp.getValue(inputDOMNode));
                        int rc = dialog.open();
                        if (rc != 0) {
                            return;
                        }
                        String attributeValue = dialog.getAttributeValue();
                        if (attributeValue == null) {
                            attributeValue = "";
                        }
                        try {
                            nsIDOMElement inputDOMElement = (nsIDOMElement)inputDOMNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                            inputDOMElement.setAttribute(attrProp.getName(), attributeValue);
                        }
                        catch (XPCOMException xpcome) {
                            MozIDEUIPlugin.log(xpcome);
                        }
                    }
                }
            }
        });
        this.getControl().setMenu(this.contextMenu);
        this.contextMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                Object inputNode = DOMAttributeViewer.this.getInput();
                if (inputNode instanceof nsIDOMNode && ((nsIDOMNode)inputNode).getNodeType() == 1) {
                    DOMAttributeViewer.this.contextMenu.getItem(0).setEnabled(true);
                    ISelection selection = DOMAttributeViewer.this.getSelection();
                    if (selection != null) {
                        IStructuredSelection strSelection = (IStructuredSelection)selection;
                        if (strSelection.size() == 1) {
                            DOMAttributeViewer.this.contextMenu.getItem(1).setEnabled(true);
                            DOMAttributeViewer.this.contextMenu.getItem(2).setEnabled(true);
                        } else {
                            DOMAttributeViewer.this.contextMenu.getItem(1).setEnabled(false);
                            DOMAttributeViewer.this.contextMenu.getItem(2).setEnabled(false);
                        }
                    }
                } else {
                    DOMAttributeViewer.this.contextMenu.getItem(0).setEnabled(false);
                    DOMAttributeViewer.this.contextMenu.getItem(1).setEnabled(false);
                    DOMAttributeViewer.this.contextMenu.getItem(2).setEnabled(false);
                }
            }
        });
    }

    protected void handleResize(ControlEvent e) {
        Rectangle area = this.getTable().getClientArea();
        TableColumn[] columns = this.getTable().getColumns();
        if (this.initialResize) {
            if (area.width > 0 && columns[0].getWidth() == 0) {
                columns[0].setWidth(area.width * 40 / 100);
                columns[1].setWidth(area.width - columns[0].getWidth() - 4);
            }
            this.initialResize = false;
        } else if (columns[0].getWidth() < area.width) {
            columns[1].setWidth(area.width - columns[0].getWidth());
        }
    }
}

