/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.compatibility.jsdt.internal.debug.ui;

import java.util.Map;
import org.eclipse.atf.compatibility.jsdt.Activator;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaScriptCore;

public class BreakpointUtils {
    private static final String HANDLE_ID = "org.eclipse.atf.compatibility.jsdt.JAVA_ELEMENT_HANDLE_ID";
    private static final String RUN_TO_LINE = "org.eclipse.atf.compatibility.jsdt.run_to_line";
    private static final String MEMBER_START = "org.eclipse.atf.compatibility.jsdt.member_start";
    private static final String MEMBER_END = "org.eclipse.atf.compatibility.jsdt.member_end";

    public static IResource getBreakpointResource(IJavaScriptElement member) {
        IResource res;
        IJavaScriptUnit cu = null;
        if (member instanceof IMember) {
            cu = ((IMember)member).getJavaScriptUnit();
        } else if (member instanceof IJavaScriptUnit) {
            cu = (IJavaScriptUnit)member;
        }
        if (cu != null && cu.isWorkingCopy()) {
            member = member.getPrimaryElement();
        }
        if ((res = member.getResource()) == null) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        } else if (!res.getProject().exists()) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        }
        return res;
    }

    public static void addJavaBreakpointAttributes(Map attributes, IJavaScriptElement element) {
        String handleId = element.getHandleIdentifier();
        attributes.put(HANDLE_ID, handleId);
        JavaScriptCore.addJavaScriptElementMarkerAttributes((Map)attributes, (IJavaScriptElement)element);
    }

    public static void addJavaBreakpointAttributesWithMemberDetails(Map attributes, IJavaScriptElement element, int memberStart, int memberEnd) {
        BreakpointUtils.addJavaBreakpointAttributes(attributes, element);
        attributes.put(MEMBER_START, new Integer(memberStart));
        attributes.put(MEMBER_END, new Integer(memberEnd));
    }

    public static void addRunToLineAttributes(Map attributes) {
        attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
        attributes.put(RUN_TO_LINE, Boolean.TRUE);
    }

    public static boolean isRunToLineBreakpoint(JSLineBreakpoint breakpoint) {
        return breakpoint.getMarker().getAttribute(RUN_TO_LINE, false);
    }

    public static boolean doesBreakpointExist(IResource res, int lineNumber) {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof JSLineBreakpoint) {
                JSLineBreakpoint breakpoint = (JSLineBreakpoint)breakpoints[i];
                try {
                    if (breakpoint.getMarker().getResource().equals((Object)res) && breakpoint.getLineNumber() == lineNumber) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static JSLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber) {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof JSLineBreakpoint) {
                JSLineBreakpoint breakpoint = (JSLineBreakpoint)breakpoints[i];
                try {
                    if (breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                        return breakpoint;
                    }
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public static JSLineBreakpoint createLineBreakpoint(IDocument document, IEditorInput input, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) {
        if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                return new JSLineBreakpoint(storage, lineNumber, -1, -1, register, attributes);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return null;
    }
}

