/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.mozilla.xpcom.IAppFileLocProvider;

public class LocationProvider
implements IAppFileLocProvider {
    private File libXULPath;
    private File profile;
    private File history;

    public LocationProvider(File aBinPath, File aProfileDir) throws IOException {
        this.libXULPath = aBinPath;
        this.profile = aProfileDir;
        if (!this.libXULPath.exists() || !this.libXULPath.isDirectory()) {
            throw new FileNotFoundException("libxul directory specified is not valid: " + this.libXULPath.getAbsolutePath());
        }
        if (!(this.profile == null || this.profile.exists() && this.profile.isDirectory())) {
            throw new FileNotFoundException("profile directory specified is not valid: " + this.profile.getAbsolutePath());
        }
        if (this.profile != null) {
            this.setupProfile();
        }
    }

    private void setupProfile() throws IOException {
        this.history = new File(this.profile, "history.dat");
        if (!this.history.exists()) {
            this.history.createNewFile();
        }
    }

    public File getFile(String aProp, boolean[] aPersistent) {
        File file = null;
        if (aProp.equals("GreD") || aProp.equals("GreComsD")) {
            file = this.libXULPath;
            if (aProp.equals("GreComsD")) {
                file = new File(file, "components");
            }
        } else if (aProp.equals("MozBinD") || aProp.equals("CurProcD") || aProp.equals("ComsD")) {
            file = this.libXULPath;
            if (aProp.equals("ComsD")) {
                file = new File(file, "components");
            }
        } else {
            if (aProp.equals("ProfD")) {
                return this.profile;
            }
            if (aProp.equals("UHist")) {
                return this.history;
            }
        }
        return file;
    }

    public File[] getFiles(String aProp) {
        File[] files = null;
        if (aProp.equals("APluginsDL")) {
            files = new File[]{new File(this.libXULPath, "plugins")};
        }
        return files;
    }
}

