/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMViewCSS;

public class DOMCompareView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.atf.mozilla.ide.ui.views.compare";
    protected Composite leftComp;
    protected Composite listComp;
    protected Composite listButtonsComp;
    protected Composite rightComp;
    protected ListViewer compareViewer;
    protected org.eclipse.swt.widgets.List compare;
    protected Map nodesToCompare = new HashMap();
    protected Table nodes;
    protected TableViewer nodeTable;
    protected SashForm displayArea;
    protected Composite buttons;
    protected Label compareLabel;
    protected Label compareListLabel;
    private Menu menu;
    private MenuItem rename;
    protected Button attributes;
    protected Button children;
    protected Button css;
    protected Button executeCompare;
    protected Button clear;
    protected Button remove;
    protected nsIDOMNode selectedNode;
    protected Color green = new Color((Device)Display.getCurrent(), new RGB(128, 255, 128));
    protected Color red = new Color((Device)Display.getCurrent(), new RGB(255, 128, 128));

    public void createPartControl(Composite parent) {
        this.displayArea = new SashForm(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.leftComp = new Composite((Composite)this.displayArea, 0);
        this.leftComp.setLayout((Layout)layout);
        this.leftComp.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.listComp = new Composite(this.leftComp, 0);
        this.listComp.setLayout((Layout)layout);
        this.listComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compareListLabel = new Label(this.listComp, 64);
        this.compareListLabel.setText("Compare List:");
        this.compare = new org.eclipse.swt.widgets.List(this.listComp, 2);
        this.compareViewer = new ListViewer(this.compare);
        this.compare.setLayoutData((Object)new GridData(4, 4, true, true));
        int ops = 3;
        this.compareViewer.addDropSupport(ops, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (DOMCompareView.this.selectedNode != null && DOMCompareView.this.selectedNode.toString().equals(event.data)) {
                    DOMCompareView.this.addNodeToCompare(DOMCompareView.this.selectedNode);
                }
            }
        });
        this.compare.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DOMCompareView.this.compareViewer.getSelection();
                DOMCompareView.this.rename.setEnabled(selection.size() == 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.listButtonsComp = new Composite(this.listComp, 0);
        this.listButtonsComp.setLayout((Layout)layout);
        this.listButtonsComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.remove = new Button(this.listButtonsComp, 8);
        this.remove.setImage(MozIDEUIPlugin.getDefault().getImage("CLOSE_TB_ID"));
        this.remove.setToolTipText("Remove Node");
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = ((IStructuredSelection)DOMCompareView.this.compareViewer.getSelection()).toArray();
                int i = 0;
                while (i < selection.length) {
                    DOMCompareView.this.compareViewer.remove(selection[i]);
                    DOMCompareView.this.nodesToCompare.remove(selection[i]);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.clear = new Button(this.listButtonsComp, 8);
        this.clear.setImage(MozIDEUIPlugin.getDefault().getImage("CLEAR_IMG_ID"));
        this.clear.setToolTipText("Clear List");
        this.clear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DOMCompareView.this.compare.removeAll();
                DOMCompareView.this.nodesToCompare.clear();
                DOMCompareView.this.clearTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttons = new Composite(this.leftComp, 2048);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.buttons.setLayout((Layout)layout);
        this.buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        this.compareLabel = new Label(this.buttons, 0);
        this.compareLabel.setText("Compare:");
        this.attributes = new Button(this.buttons, 16);
        this.attributes.setText("DOM Attributes");
        this.attributes.setSelection(true);
        this.children = new Button(this.buttons, 16);
        this.children.setText("Child Nodes");
        this.css = new Button(this.buttons, 16);
        this.css.setText("CSS");
        this.executeCompare = new Button(this.buttons, 8);
        this.executeCompare.setText("Compare");
        this.executeCompare.setToolTipText("Compare nodes");
        this.executeCompare.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DOMCompareView.this.attributes.getSelection()) {
                    DOMCompareView.this.compareAttributes();
                } else if (DOMCompareView.this.css.getSelection()) {
                    DOMCompareView.this.compareCSS();
                } else if (DOMCompareView.this.children.getSelection()) {
                    DOMCompareView.this.compareChildren();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.rightComp = new Composite((Composite)this.displayArea, 0);
        this.rightComp.setLayout((Layout)layout);
        this.rightComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nodes = new Table(this.rightComp, 65536);
        this.nodes.setHeaderVisible(true);
        this.nodes.setLinesVisible(true);
        this.nodeTable = new TableViewer(this.nodes);
        this.nodes.setLayoutData((Object)new GridData(4, 4, true, true));
        this.menu = new Menu((Control)this.compare);
        this.menu.setEnabled(true);
        this.rename = new MenuItem(this.menu, 8);
        this.rename.setText("Rename node");
        this.rename.setEnabled(false);
        this.rename.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String node = DOMCompareView.this.compare.getSelection()[0];
                int index = DOMCompareView.this.compare.getSelectionIndex();
                InputDialog renameDialog = new InputDialog(DOMCompareView.this.rename.getParent().getShell(), "Rename node", "Node Name:", node, null);
                if (renameDialog.open() == 0) {
                    DOMCompareView.this.compare.setItem(index, renameDialog.getValue());
                    DOMCompareView.this.nodesToCompare.put(renameDialog.getValue(), DOMCompareView.this.nodesToCompare.remove(node));
                    DOMCompareView.this.nodeTable.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compare.setMenu(this.menu);
        this.displayArea.setWeights(new int[]{15, 85});
    }

    public void addNodeToCompare(nsIDOMNode node) {
        String hash = this.hashNode(node);
        this.compareViewer.add((Object)hash);
        this.nodesToCompare.put(hash, node);
    }

    private void clearTable() {
        this.nodes.removeAll();
        TableColumn[] columns = this.nodes.getColumns();
        int count = 0;
        while (count < columns.length) {
            columns[count].dispose();
            ++count;
        }
    }

    public void dispose() {
        this.green.dispose();
        this.red.dispose();
        super.dispose();
    }

    private String hashNode(nsIDOMNode node) {
        nsIDOMElement element;
        String hash = String.valueOf(node.getNodeName()) + "[" + node.hashCode() + "]";
        if (node.getNodeType() == 1 && (element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("id") != null && element.getAttribute("id").length() > 0) {
            hash = String.valueOf(node.getNodeName()) + "[" + element.getAttribute("id") + "]";
        }
        return hash;
    }

    private void compareAttributes() {
        this.clearTable();
        ArrayList<TableItem> tableItems = new ArrayList<TableItem>();
        Object[] keys = this.nodesToCompare.keySet().toArray();
        int space = this.nodes.getBounds().width;
        int i = 0;
        while (i < keys.length) {
            nsIDOMNode node = (nsIDOMNode)this.nodesToCompare.get(keys[i]);
            nsIDOMNamedNodeMap attrs = node.getAttributes();
            TableColumn column = new TableColumn(this.nodes, 16384);
            column.setText(keys[i].toString());
            column.setWidth(space / keys.length);
            column.setResizable(true);
            if (attrs != null) {
                int j = 0;
                while ((long)j < attrs.getLength()) {
                    TableItem tableItem;
                    String name = attrs.item((long)j).getNodeName();
                    String value = attrs.item((long)j).getNodeValue();
                    if (j < tableItems.size()) {
                        tableItem = (TableItem)tableItems.get(j);
                    } else {
                        tableItem = new TableItem(this.nodes, 0);
                        tableItems.add(tableItem);
                    }
                    tableItem.setText(i, String.valueOf(name) + ":" + value);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void compareCSS() {
        this.clearTable();
        ArrayList<TableItem> tableItems = new ArrayList<TableItem>();
        Object[] keys = this.nodesToCompare.keySet().toArray();
        int space = this.nodes.getBounds().width;
        int i = 0;
        while (i < keys.length) {
            nsIDOMNode node = (nsIDOMNode)this.nodesToCompare.get(keys[i]);
            nsIDOMNamedNodeMap attrs = node.getAttributes();
            TableColumn column = new TableColumn(this.nodes, 16384);
            column.setText(keys[i].toString());
            column.setWidth(space / keys.length);
            column.setResizable(true);
            if (attrs != null && node.getNodeType() == 1) {
                nsIDOMElement domElement = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                nsIDOMDocumentView documentView = (nsIDOMDocumentView)domElement.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
                nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
                nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(domElement, "");
                int j = 0;
                while ((long)j < computedStyle.getLength()) {
                    TableItem tableItem;
                    String name = computedStyle.item((long)j);
                    String value = computedStyle.getPropertyCSSValue(computedStyle.item((long)j)).getCssText();
                    if (j < tableItems.size()) {
                        tableItem = (TableItem)tableItems.get(j);
                    } else {
                        tableItem = new TableItem(this.nodes, 0);
                        tableItems.add(tableItem);
                    }
                    tableItem.setText(i, String.valueOf(name) + ":" + value);
                    ++j;
                }
            }
            ++i;
        }
        this.highlightTable(tableItems);
    }

    private void compareChildren() {
        this.clearTable();
        ArrayList<TableItem> tableItems = new ArrayList<TableItem>();
        Object[] keys = this.nodesToCompare.keySet().toArray();
        int space = this.nodes.getBounds().width;
        int i = 0;
        while (i < keys.length) {
            nsIDOMNode node = (nsIDOMNode)this.nodesToCompare.get(keys[i]);
            nsIDOMNodeList children = node.getChildNodes();
            TableColumn column = new TableColumn(this.nodes, 16384);
            column.setText(keys[i].toString());
            column.setWidth(space / keys.length);
            column.setResizable(true);
            if (children != null) {
                int j = 0;
                while ((long)j < children.getLength()) {
                    TableItem tableItem;
                    String name = children.item((long)j).getNodeName();
                    if (j < tableItems.size()) {
                        tableItem = (TableItem)tableItems.get(j);
                    } else {
                        tableItem = new TableItem(this.nodes, 0);
                        tableItems.add(tableItem);
                    }
                    tableItem.setText(i, name);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void highlightTable(List tableItems) {
        if (this.nodesToCompare.size() > 1) {
            for (TableItem item : tableItems) {
                int columns = item.getParent().getColumnCount();
                int max_matches = 0;
                String max_string = "";
                int i = 0;
                while (i < columns) {
                    int curr_matches = 0;
                    int j = 0;
                    while (j < columns) {
                        if (i != j && item.getText(i).equals(item.getText(j))) {
                            ++curr_matches;
                        }
                        ++j;
                    }
                    max_string = curr_matches > max_matches ? item.getText(i) : max_string;
                    max_matches = curr_matches > max_matches ? curr_matches : max_matches;
                    ++i;
                }
                i = 0;
                while (i < columns) {
                    if (item.getText(i).equals(max_string)) {
                        item.setBackground(i, this.green);
                    } else {
                        item.setBackground(i, this.red);
                    }
                    ++i;
                }
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IDOMNodeSelection) {
            this.selectedNode = ((IDOMNodeSelection)selection).getSelectedNode();
        }
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addSelectionListener((ISelectionListener)this);
        super.init(site);
    }
}

