/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActionExtensionManager {
    public static final String ACTION_POINT = "org.eclipse.atf.mozilla.ide.ui.action";
    public static final String ITEM_NODE = "action";
    public static final String CLASS_ATTR = "class";
    public static final String TEXT_ATTR = "text";
    public static final String ICON_ATTR = "icon";
    public static final String TYPES_ATTR = "types";
    public static final String PATH_ATTR = "path";
    private static MenuManager manager = null;
    private static Map actionGroups = new HashMap();
    private static List configurables = null;

    public static Menu configure(Control control, IDOMNodeSelection selection) {
        manager = new MenuManager();
        actionGroups.clear();
        if (configurables == null) {
            configurables = new ArrayList();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint(ACTION_POINT);
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    if (ce[j].getName().equals(ITEM_NODE)) {
                        configurables.add(ce[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < configurables.size()) {
            ActionExtensionManager.configureAction((IConfigurationElement)configurables.get(i), selection);
            ++i;
        }
        Object[] keys = actionGroups.keySet().toArray();
        int i2 = 0;
        while (i2 < keys.length) {
            List actions = (List)actionGroups.get(keys[i2]);
            MenuManager subManager = null;
            int j = 0;
            while (j < actions.size()) {
                DOMSelectionAction action = (DOMSelectionAction)((Object)actions.get(j));
                if (action.getPath().indexOf(47) != -1) {
                    if (subManager == null) {
                        if (manager.indexOf(action.getPath()) != -1) {
                            subManager = (MenuManager)manager.getItems()[manager.indexOf(action.getPath())];
                        } else {
                            subManager = new MenuManager(action.getPath().substring(action.getPath().indexOf(47) + 1, action.getPath().length()), action.getPath());
                            manager.add((IContributionItem)subManager);
                        }
                    }
                    subManager.add((IAction)action);
                } else {
                    manager.add((IAction)action);
                }
                ++j;
            }
            manager.add((IContributionItem)new Separator());
            ++i2;
        }
        return manager.createContextMenu(control);
    }

    private static void configureAction(IConfigurationElement element, IDOMNodeSelection selection) {
        String group;
        String menuitem = element.getAttribute(CLASS_ATTR);
        String text = element.getAttribute(TEXT_ATTR);
        String icon = element.getAttribute(ICON_ATTR);
        String types = element.getAttribute(TYPES_ATTR);
        String path = element.getAttribute(PATH_ATTR);
        path = path == null ? "ROOT" : path;
        String string = group = path.indexOf(47) != -1 ? path.substring(0, path.indexOf(47)) : path;
        if (menuitem != null && text != null && icon != null) {
            try {
                String pluginID = element.getContributor().getName();
                Object item = element.createExecutableExtension(CLASS_ATTR);
                if (item instanceof DOMSelectionAction) {
                    DOMSelectionAction action = (DOMSelectionAction)((Object)item);
                    if (types != null) {
                        action.setTypes(types);
                    }
                    action.setPath(path);
                    List<DOMSelectionAction> list = actionGroups.containsKey(group) ? (List)actionGroups.get(group) : new ArrayList();
                    list.add(action);
                    actionGroups.put(group, list);
                    manager.addMenuListener((IMenuListener)action);
                    action.setText(text);
                    action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginID, (String)icon));
                    action.setSelection(selection);
                }
            }
            catch (Exception exception) {}
        }
    }
}

