/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIWebBrowser;

public class MozBrowserProcess
extends PlatformObject
implements IProcess {
    private IWebBrowser _webBrowser;
    private Browser _browser;
    private CloseWindowListener _closeListener;
    private DisposeListener _disposeListener;
    private ILaunch _launch;
    private int _exitValue = 0;
    private boolean _terminated;

    public MozBrowserProcess(IWebBrowser webBrowser, ILaunch launch) {
        this._webBrowser = webBrowser;
        this._browser = (Browser)webBrowser.getAdapter(Browser.class);
        this._launch = launch;
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
        this._closeListener = new CloseWindowListener(){

            public void close(WindowEvent event) {
                MozBrowserProcess.this.processTermination();
            }
        };
        this._browser.addCloseWindowListener(this._closeListener);
        this._disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MozBrowserProcess.this.processTermination();
            }
        };
        this._browser.addDisposeListener(this._disposeListener);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this._terminated;
    }

    public void terminate() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Browser browser = MozBrowserProcess.this._browser;
                MozBrowserProcess.this.processTermination();
                browser.dispose();
            }
        });
    }

    protected void processTermination() {
        if (this._browser != null && !this._browser.isDisposed() && this._closeListener != null) {
            this._browser.removeCloseWindowListener(this._closeListener);
        }
        this.fireTerminateEvent();
        this._browser = null;
        this._closeListener = null;
        this._terminated = true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        if (nsIBaseWindow.class.equals((Object)adapter)) {
            return (nsIBaseWindow)((nsIWebBrowser)this._browser.getWebBrowser()).queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}");
        }
        if (nsIWebBrowser.class.equals((Object)adapter)) {
            return this._browser != null ? this._browser.getWebBrowser() : null;
        }
        if (IWebBrowser.class.equals((Object)adapter)) {
            return this._webBrowser;
        }
        if (Browser.class.equals((Object)adapter)) {
            return this._browser;
        }
        return super.getAdapter(adapter);
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", 0, "process still running. exit value unknown", null));
        }
        return this._exitValue;
    }

    public String getLabel() {
        return "Mozilla Browser";
    }

    public ILaunch getLaunch() {
        return this._launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        DebugEvent event = new DebugEvent((Object)this, 8);
        event.setData((Object)this._browser);
        this.fireEvent(event);
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }
}

