/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.util.MozBrowserUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenMozBrowserEditorAction
extends Action
implements IWorkbenchWindowActionDelegate {
    protected static final String ERROR_MSG = "Error opening Mozilla Browser!";

    public void run() {
        try {
            IWorkbenchWindow activeWindow = MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", 4, "Error opening Mozilla Browser... failed to retrieve active workbench window!", null));
            }
            IWorkbenchPage activePage = activeWindow.getActivePage();
            if (activePage == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", 4, "Error opening Mozilla Browser... could not retrieve active page!", null));
            }
            InputDialog urlDialog = new InputDialog(activePage.getWorkbenchWindow().getShell(), "Open URL...", "Enter URL: ", "http://", null);
            int rc = urlDialog.open();
            if (rc != 0) {
                return;
            }
            String urlString = urlDialog.getValue();
            MozBrowserUtil.openMozillaBrowser(urlString, activePage);
        }
        catch (CoreException e) {
            this.showError(e.getStatus());
        }
    }

    protected void showError(IStatus status) {
        try {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)ERROR_MSG, (IStatus)status);
        }
        catch (Exception exception) {}
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

