/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser.toolbar;

import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.BrowserToolbar;
import org.eclipse.atf.mozilla.ide.ui.common.SelectionProviderHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.progress.WorkbenchJob;
import org.mozilla.interfaces.nsIDOMNode;

public class DOMSelectionBar
extends BrowserToolbar
implements SelectionListener {
    private static final String SELECTED = "Selected: ";
    private static final String HOVERED = "Hovered: ";
    private static final String NONE = "None";
    protected IWebBrowser browser;
    protected Link domPath = null;
    protected nsIDOMNode node = null;
    protected Job refreshJob = null;
    protected SelectionProviderHandler handler;
    protected ListenerList listeners = new ListenerList();

    public void dispose() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
    }

    protected void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("DOMSelectionBar: Restore to Selection"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DOMSelectionBar.this.updateSelectedPath();
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    /*
     * Unable to fully structure code
     */
    private void updateSelectedPath() {
        block4: {
            block5: {
                block3: {
                    if (this.domPath.getParent() == null || this.domPath.getParent().isDisposed()) {
                        return;
                    }
                    if (this.node != null) break block3;
                    this.domPath.setText("Selected: None");
                    break block4;
                }
                path = new StringBuffer("");
                count = 0;
                _node = this.node;
                if (!_node.getNodeName().equals("#document")) ** GOTO lbl19
                path.insert(0, "<A HREF=\"" + count + "\">" + _node.getNodeName() + "</A>");
                break block5;
lbl-1000:
                // 1 sources

                {
                    if (!_node.getNodeName().equals("#document")) {
                        path.insert(0, "/<A HREF=\"" + count + "\">" + _node.getNodeName() + "</A>");
                    }
                    ++count;
                    _node = _node.getParentNode();
lbl19:
                    // 2 sources

                    ** while (_node != null)
                }
lbl20:
                // 1 sources

                path.deleteCharAt(0);
            }
            path.insert(0, "Selected: ");
            this.domPath.setText(path.toString());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.node != null) {
            nsIDOMNode selected = this.node;
            int i = 0;
            while (i < Integer.parseInt(e.text)) {
                selected = selected.getParentNode();
                ++i;
            }
            final nsIDOMNode node = selected;
            this.browser.setSelection(new IDOMNodeSelection(){

                public boolean isEmpty() {
                    return false;
                }

                public nsIDOMNode getSelectedNode() {
                    return node;
                }
            });
        }
    }

    public void fillToolbar(Composite parent) {
        this.domPath = new Link(parent, 256);
        this.domPath.setText("Selected: None");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.domPath.setLayoutData((Object)data);
        this.domPath.addSelectionListener((SelectionListener)this);
        this.createRefreshJob();
    }

    public void show(boolean show) {
        if (this.node != null) {
            this.updateSelectedPath();
        }
        super.show(show);
    }

    /*
     * Unable to fully structure code
     */
    public void setHoverSelection(IDOMNodeSelection selection) {
        block2: {
            block3: {
                if (selection == null || selection.isEmpty() || (tempNode = selection.getSelectedNode()) == null) break block2;
                this.refreshJob.cancel();
                path = new StringBuffer("");
                count = 0;
                _node = tempNode;
                if (!_node.getNodeName().equals("#document")) ** GOTO lbl16
                path.insert(0, _node.getNodeName());
                break block3;
lbl-1000:
                // 1 sources

                {
                    if (!_node.getNodeName().equals("#document")) {
                        path.insert(0, "/" + _node.getNodeName());
                    }
                    ++count;
                    _node = _node.getParentNode();
lbl16:
                    // 2 sources

                    ** while (_node != null)
                }
lbl17:
                // 1 sources

                path.deleteCharAt(0);
            }
            path.insert(0, "Hovered: ");
            this.domPath.setText(path.toString());
            this.refreshJob.schedule(500L);
        }
    }

    public void setNodeSelection(IDOMNodeSelection selection) {
        if (this.domPath == null || this.domPath.isDisposed()) {
            return;
        }
        this.node = selection != null && !selection.isEmpty() ? selection.getSelectedNode() : null;
        this.updateSelectedPath();
    }

    public void setBrowser(IWebBrowser browser) {
        this.browser = browser;
    }
}

