/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.ui.css.CSSContentProvider;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.jface.viewers.Viewer;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMViewCSS;

public class ComputedStylesContentProvider
extends CSSContentProvider {
    private void parseComputedStyles() {
        CSSProperty property;
        this.parseNodes();
        this.nodeMap.clear();
        ArrayList<CSSProperty> computedStyles = new ArrayList<CSSProperty>();
        nsIDOMElement domElement = (nsIDOMElement)this.currentNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        nsIDOMDocumentView documentView = (nsIDOMDocumentView)domElement.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
        nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
        nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(domElement, "");
        int i = 0;
        while ((long)i < computedStyle.getLength()) {
            property = new CSSProperty(computedStyle.item((long)i), computedStyle.getPropertyCSSValue(computedStyle.item((long)i)).getCssText(), "", "", "Computed Styles");
            computedStyles.add(property);
            property.setProperty(true);
            if (this.definedProperties.containsKey(property.getName())) {
                property.setPresent(true);
                CSSProperty defined = (CSSProperty)this.definedProperties.get(property.getName());
                property.setURL(defined.getURL());
                property.setLineNumber(defined.getLineNumber());
                property.setComputed(true);
            }
            ++i;
        }
        property = new CSSProperty("", "", "", "", "Computed Styles");
        property.setProperty(false);
        this.nodeMap.put(property, computedStyles);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput instanceof nsIDOMNode) {
            this.currentNode = (nsIDOMNode)newInput;
            this.parseComputedStyles();
        }
    }

    public Map getComputedStyles() {
        return this.nodeMap;
    }
}

