/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.domwatcher;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.IDOMEventWatcherListener;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.model.DOMEvent;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.model.IDOMEvent;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.DOMWatcherSettings;
import org.eclipse.atf.mozilla.ide.ui.util.DOMNodeUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

public class Watcher {
    protected nsIDOMNode watchedNode = null;
    protected List events = new ArrayList();
    protected boolean watching = false;
    protected boolean disconnected;
    protected ListenerList listeners = new ListenerList();
    protected nsIDOMEventListener domEventListener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent domEvent) {
            nsIDOMEventTarget eventTarget = domEvent.getTarget();
            if (Watcher.this.watchedNode.equals((nsIDOMNode)eventTarget.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"))) {
                Date date = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm.ss.SSSS");
                String time = formatter.format((Object)date);
                final DOMEvent newEvent = new DOMEvent(time, domEvent.getType(), DOMWatcherSettings.getInstance().getSetting(domEvent.getType()).getDetailProvider().getDetail(domEvent), "");
                Watcher.this.events.add(newEvent);
                UIJob job = new UIJob("Fire New DOM Event"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Watcher.this.fireNewEvent(newEvent);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected String nodeAsString = null;

    public Watcher(nsIDOMNode node) {
        this.watchedNode = node;
        this.disconnected = false;
    }

    protected nsIDOMEventTarget getEventTarget() {
        if (this.watchedNode.getNodeType() == 9) {
            return (nsIDOMEventTarget)this.watchedNode.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        }
        return (nsIDOMEventTarget)this.watchedNode.getOwnerDocument().queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
    }

    public nsIDOMNode getWatchedNode() {
        return this.watchedNode;
    }

    public IDOMEvent[] getEvents() {
        IDOMEvent[] eventArray = new IDOMEvent[this.events.size()];
        return this.events.toArray(eventArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Watcher watcher = this;
        synchronized (watcher) {
            if (this.isDisconnected() || this.isWatching()) {
                return;
            }
            nsIDOMEventTarget eventTarget = this.getEventTarget();
            String[] eventTypes = DOMWatcherSettings.getInstance().getSupportedEventTypes();
            int i = 0;
            while (i < eventTypes.length) {
                if (DOMWatcherSettings.getInstance().getSetting(eventTypes[i]).shouldWatch()) {
                    eventTarget.addEventListener(eventTypes[i], this.domEventListener, true);
                }
                ++i;
            }
            this.watching = true;
        }
        DOMEvent startEvent = new DOMEvent("", "START WATCH", "", "");
        this.events.add(startEvent);
        this.fireNewEvent(startEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Watcher watcher = this;
        synchronized (watcher) {
            if (this.isDisconnected() || !this.isWatching()) {
                return;
            }
            nsIDOMEventTarget eventTarget = this.getEventTarget();
            String[] eventTypes = DOMWatcherSettings.getInstance().getSupportedEventTypes();
            int i = 0;
            while (i < eventTypes.length) {
                try {
                    eventTarget.removeEventListener(eventTypes[i], this.domEventListener, true);
                }
                catch (Exception exception) {}
                ++i;
            }
            this.watching = false;
        }
        DOMEvent endEvent = new DOMEvent("", "STOP WATCH", "", "");
        this.events.add(endEvent);
        this.fireNewEvent(endEvent);
    }

    public void clear() {
        this.events.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Watcher watcher = this;
        synchronized (watcher) {
            this.stop();
            this.disconnected = true;
            this.listeners.clear();
        }
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean isWatching() {
        return this.watching;
    }

    protected void fireNewEvent(IDOMEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            IDOMEventWatcherListener listener = (IDOMEventWatcherListener)this.listeners.getListeners()[i];
            listener.newEvent(event);
            ++i;
        }
    }

    public void addListener(IDOMEventWatcherListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IDOMEventWatcherListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.nodeAsString == null) {
            this.nodeAsString = DOMNodeUtils.nodeToString(this.watchedNode);
        }
        buf.append(this.nodeAsString);
        if (this.isDisconnected()) {
            buf.append("  <<disconnected>>");
        }
        return buf.toString();
    }
}

