/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.domwatcher.model;

import org.eclipse.atf.mozilla.ide.ui.domwatcher.model.IDOMEventDetailProvider;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;

public class DOMMouseEventDetailProvider
implements IDOMEventDetailProvider {
    public String getDetail(nsIDOMEvent event) {
        nsIDOMMouseEvent mEvent = (nsIDOMMouseEvent)event.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        StringBuffer details = new StringBuffer();
        details.append("screen(");
        details.append(mEvent.getScreenX());
        details.append(',');
        details.append(mEvent.getScreenY());
        details.append(") ");
        details.append("client(");
        details.append(mEvent.getClientX());
        details.append(',');
        details.append(mEvent.getClientY());
        details.append(") ");
        if ("click".equals(event.getType()) || "mousedown".equals(event.getType()) || "mouseup".equals(event.getType())) {
            switch (mEvent.getButton()) {
                case 0: {
                    details.append("LEFT ");
                    break;
                }
                case 1: {
                    details.append("MIDDLE ");
                    break;
                }
                case 2: {
                    details.append("RIGHT ");
                }
            }
        }
        if (mEvent.getShiftKey()) {
            details.append("Shift ");
        }
        if (mEvent.getCtrlKey()) {
            details.append("Ctrl ");
        }
        if (mEvent.getAltKey()) {
            details.append("Alt ");
        }
        if (mEvent.getMetaKey()) {
            details.append("Meta ");
        }
        return details.toString();
    }
}

