/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.preferences;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BrowserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static final String PAGE_TITLE = "Browser Settings";
    protected static final String PAGE_DESC = "Various settings controlling the embedded browser.";
    protected static final String POPUP_HANDLING_LABEL_TEXT = "Popup Window Handling:";
    protected static final String[] POPUP_HANDLING_OPTIONS = new String[]{"Open in new Browser Editor", "Open as a Dialog", "Ignore", "Prompt"};
    protected static final int AS_EDITOR_IDX = 0;
    protected static final int AS_DIALOG_IDX = 1;
    protected static final int IGNORE_IDX = 2;
    protected static final int PROMPT_IDX = 3;
    protected String popUpHanding = null;

    public BrowserPreferencePage() {
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        Composite displayArea = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.grabExcessHorizontalSpace = true;
        displayArea.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        displayArea.setLayout((Layout)layout);
        Label popupHandlingLabel = new Label(displayArea, 16448);
        popupHandlingLabel.setFont(displayArea.getFont());
        popupHandlingLabel.setText(POPUP_HANDLING_LABEL_TEXT);
        layoutData = new GridData();
        layoutData.horizontalSpan = 1;
        layoutData.horizontalAlignment = 4;
        popupHandlingLabel.setLayoutData((Object)layoutData);
        Combo popupHandlingCombo = new Combo(displayArea, 2060);
        popupHandlingCombo.setFont(displayArea.getFont());
        popupHandlingCombo.setItems(POPUP_HANDLING_OPTIONS);
        if (this.popUpHanding.equals("editor")) {
            popupHandlingCombo.setText(POPUP_HANDLING_OPTIONS[0]);
        } else if (this.popUpHanding.equals("dialog")) {
            popupHandlingCombo.setText(POPUP_HANDLING_OPTIONS[1]);
        } else if (this.popUpHanding.equals("ignore")) {
            popupHandlingCombo.setText(POPUP_HANDLING_OPTIONS[2]);
        } else if (this.popUpHanding.equals("prompt")) {
            popupHandlingCombo.setText(POPUP_HANDLING_OPTIONS[3]);
        }
        layoutData = new GridData();
        layoutData.horizontalSpan = 1;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.widthHint = this.convertWidthInCharsToPixels(50);
        popupHandlingCombo.setLayoutData((Object)layoutData);
        popupHandlingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int selectedIdx = ((Combo)e.widget).getSelectionIndex();
                switch (selectedIdx) {
                    case 0: {
                        BrowserPreferencePage.this.popUpHanding = "editor";
                        break;
                    }
                    case 1: {
                        BrowserPreferencePage.this.popUpHanding = "dialog";
                        break;
                    }
                    case 2: {
                        BrowserPreferencePage.this.popUpHanding = "ignore";
                        break;
                    }
                    case 3: {
                        BrowserPreferencePage.this.popUpHanding = "prompt";
                    }
                }
            }
        });
        return displayArea;
    }

    public void init(IWorkbench workbench) {
        this.popUpHanding = MozIDEUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.atf.mozilla.ide.uipopupHandling");
    }

    public boolean performOk() {
        MozIDEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.atf.mozilla.ide.uipopupHandling", this.popUpHanding);
        return super.performOk();
    }
}

