/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class TerminateProcessActionDelegate
extends AbstractListenerActionDelegate {
    public void run(Object obj, INavigator fViewer) {
        TRCProcessProxy process = null;
        process = obj instanceof TRCAgentProxy ? ((TRCAgentProxy)obj).getProcessProxy() : (TRCProcessProxy)obj;
        String title = TraceMessages.TRC_MSGT;
        String msg = NLS.bind((String)TraceMessages.TERMINATE_Q, (Object[])new Object[]{process.getName(), String.valueOf(process.getPid())});
        if (!MessageDialog.openQuestion((Shell)fViewer.getViewSite().getShell(), (String)title, (String)msg)) {
            return;
        }
        String host = process.getNode().getName();
        Node node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(process.getNode().getPort()));
        if (node == null) {
            return;
        }
        Process p = node.getProcess(String.valueOf(process.getPid()));
        try {
            if (p != null && p.isActive()) {
                node.killProcess(p);
            }
        }
        catch (NotConnectedException exc1) {
            exc1.printStackTrace();
        }
        catch (InactiveProcessException exc2) {
            exc2.printStackTrace();
        }
        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
        event.setSource((Object)process);
        event.setType(16);
        UIPlugin.getDefault().notifyProfileEventListener(event);
    }

    protected boolean isEnabledFor(Object element) {
        return element != null && (element instanceof TRCAgentProxy && ((TRCAgentProxy)element).isActive() || element instanceof TRCProcessProxy && ((TRCProcessProxy)element).isActive());
    }

    public void doAction(Object object) throws Exception {
        if (object == null) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run(object, fViewer);
    }

    public void dispose() {
        super.dispose();
    }
}

