/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.hyades.log.ui.internal.OpenLogAgentWizard;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;

public class TraceLogActionGroup
extends org.eclipse.tptp.platform.common.ui.trace.internal.actions.TraceLogActionGroup {
    protected OpenWizardAction fOpenLogAgentAction;

    public TraceLogActionGroup(INavigator viewer) {
        super(viewer);
    }

    protected void createActions() {
        super.createActions();
        this.fOpenLogAgentAction = new OpenWizardAction(this.getNavigator(), OpenLogAgentWizard.class, UIPlugin.getResourceString(TraceMessages.PROP));
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.openReportAction.selectionChanged((IStructuredSelection)this.getContext().getSelection());
        if (this.openReportAction.isApplicableForSelection()) {
            menu.appendToGroup("group.import", (IAction)this.openReportAction);
        }
    }

    public void fillContextMenuWithGroups(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    protected IAction getDefaultAction(Object obj) {
        IAction action;
        TreeSet<ProfileDetailItem> children = new TreeSet<ProfileDetailItem>(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof INavigatorItem && o2 instanceof INavigatorItem) {
                    return ((INavigatorItem)o1).getText().compareTo(((INavigatorItem)o2).getText());
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        if (obj instanceof TRCMonitor) {
            IAction action2 = this.getDefaultViewMappingForType("Monitor");
            if (action2 != null) {
                return action2;
            }
            children.addAll((Collection<ProfileDetailItem>)((TRCMonitor)obj).getNodes());
        } else if (obj instanceof TRCNode) {
            IAction action3 = this.getDefaultViewMappingForType("Host");
            if (action3 != null) {
                return action3;
            }
            children.addAll((Collection<ProfileDetailItem>)((TRCNode)obj).getProcessProxies());
        } else if (obj instanceof TRCProcessProxy) {
            children.addAll((Collection<ProfileDetailItem>)((TRCProcessProxy)obj).getAgentProxies());
        } else if (obj instanceof CorrelationContainerProxy) {
            children.addAll((Collection<ProfileDetailItem>)((CorrelationContainerProxy)obj).getCorrelatedAgents());
        } else if (obj instanceof TRCAgentProxy) {
            IAction action4;
            children.addAll(NavigatorExtensionUtil.getAllChildren((Object)obj, (String)"org.eclipse.hyades.trace.ui.profileNavigator"));
            if (((TRCAgentProxy)obj).getType().equals("Profiler") && !this.hasProfilingTypes(obj)) {
                IAction action5 = this.getDefaultViewMappingForType(((TRCAgentProxy)obj).getType());
                if (action5 != null) {
                    return action5;
                }
                Map typesMap = ProfilingSetsManager.instance().getProfilingTypes();
                for (IProfilingSetType next : typesMap.values()) {
                    children.add(new ProfileDetailItem(obj, next.getName(), next.getId(), null));
                }
            }
            boolean hasViewer = false;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                if (this.getDefaultAction(iter.next()) == null) continue;
                hasViewer = true;
                break;
            }
            if (!hasViewer && (action4 = this.getDefaultViewMappingForType(((TRCAgentProxy)obj).getType())) != null) {
                return action4;
            }
        } else if (obj instanceof INavigatorItem && (action = this.getDefaultViewMappingForType(((INavigatorItem)obj).getType())) != null) {
            return action;
        }
        children.addAll(NavigatorExtensionUtil.getAllChildren((Object)obj, (String)"org.eclipse.hyades.trace.ui.profileNavigator"));
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IAction action6 = this.getDefaultAction(iter.next());
            if (action6 == null) continue;
            return action6;
        }
        return null;
    }

    protected boolean hasProfilingTypes(Object obj) {
        Iterator iter = NavigatorExtensionUtil.getAllChildren((Object)obj, (String)"org.eclipse.hyades.trace.ui.profileNavigator").iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof ProfileDetailItem)) continue;
            return true;
        }
        return false;
    }

    class ImportActionGroup
    extends ActionGroup {
        private ImportResourcesAction fImportAction;
        private ExportResourcesAction fExportAction;

        public ImportActionGroup(INavigator part) {
            IWorkbenchWindow workbench = part.getSite().getWorkbenchWindow();
            this.fImportAction = new ImportResourcesAction(workbench);
            this.fExportAction = new ExportResourcesAction(workbench);
            PDPluginImages.setImageDescriptors((IAction)this.fImportAction, "lcl16", "import_wiz.gif");
            PDPluginImages.setImageDescriptors((IAction)this.fExportAction, "lcl16", "export_wiz.gif");
        }

        public void fillContextMenu(IMenuManager menu) {
            menu.appendToGroup("group.import", (IAction)this.fImportAction);
            menu.appendToGroup("group.import", (IAction)this.fExportAction);
            super.fillContextMenu(menu);
        }
    }
}

