/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachAgentTabProviders;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeContentProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILaunchValidator;

public class ProfileLaunchUtil {
    public static boolean changeParentGrayState(CheckboxTreeViewer checkBoxTreeViewer, CheckStateChangedEvent event) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)checkBoxTreeViewer.getContentProvider();
        Object parent = contentProvider.getParent(event.getElement());
        Object[] siblings = contentProvider.getChildren(parent);
        boolean foundChecked = event.getChecked();
        boolean foundUnchecked = false;
        if (siblings != null) {
            int i = 0;
            while (!(i >= siblings.length || foundChecked && foundUnchecked)) {
                if (checkBoxTreeViewer.getChecked(siblings[i])) {
                    foundChecked = true;
                } else {
                    foundUnchecked = true;
                }
                ++i;
            }
        }
        checkBoxTreeViewer.setChecked(parent, foundChecked);
        checkBoxTreeViewer.setGrayed(parent, foundChecked && foundUnchecked);
        return foundChecked;
    }

    public static void changeItemCheckedState(CheckboxTreeViewer checkBoxTreeViewer, ICheckStateListener listener, Object item, boolean checked) {
        checkBoxTreeViewer.setChecked(item, checked);
        CheckStateChangedEvent checkStateEvent = new CheckStateChangedEvent((ICheckable)checkBoxTreeViewer, item, checked);
        listener.checkStateChanged(checkStateEvent);
    }

    public static Object updateButtonStatus(ILaunchConfiguration configuration, SelectionChangedEvent event, Button editOptions, Button testAvailability, CheckboxTreeViewer checkboxTreeViewer, ICheckStateListener checkStateListener) {
        ISelection selectedElementObj = event.getSelection();
        Object selectedElement = null;
        if (!(selectedElementObj instanceof StructuredSelection)) {
            return null;
        }
        selectedElement = ((StructuredSelection)selectedElementObj).getFirstElement();
        LightConfigurationLoader configurationLoader = null;
        boolean isConfigurationPreset = false;
        boolean isButtonStatusSet = false;
        IProfilingSetType profilingSetType = null;
        boolean editOptionState = false;
        boolean testAvailabilityState = false;
        DataCollectorAssociationData dcAssociationData = LauncherUtility.findDataCollectorAssociationData(configuration, selectedElement);
        Object childNode = null;
        if (dcAssociationData != null) {
            configurationLoader = dcAssociationData.getConfigurationLoader();
        } else if (selectedElement instanceof DataCollectorTreeContentProvider.ParentChildNode) {
            childNode = ((DataCollectorTreeContentProvider.ParentChildNode)selectedElement).child;
        } else if (selectedElement instanceof AttachAgentTabProviders.AgentTreeItem) {
            childNode = ((AttachAgentTabProviders.AgentTreeItem)selectedElement).getAnalysisType();
            Object object = childNode = childNode == null ? ((AttachAgentTabProviders.AgentTreeItem)selectedElement).getProfilingType() : childNode;
        }
        if (childNode != null) {
            if (childNode instanceof AnalysisType) {
                configurationLoader = ((AnalysisType)childNode).getConfigurationLoader();
            } else if (childNode instanceof IProfilingSetType) {
                profilingSetType = (IProfilingSetType)childNode;
                editOptionState = true;
                isButtonStatusSet = true;
            }
        }
        if (!isButtonStatusSet) {
            isConfigurationPreset = configurationLoader != null;
            editOptionState = isConfigurationPreset && configurationLoader.isEditable();
            boolean bl = testAvailabilityState = isConfigurationPreset && configurationLoader.getAvailabilityTester() != null;
        }
        if (editOptions != null) {
            editOptions.setEnabled(editOptionState);
            ProfileLaunchUtil.injectDataInButton(editOptions, new Object[][]{{"0", configuration}, {"1", configurationLoader}, {"2", profilingSetType}, {"3", checkboxTreeViewer}, {"4", checkStateListener}});
        }
        if (testAvailability != null) {
            testAvailability.setEnabled(testAvailabilityState);
            ProfileLaunchUtil.injectDataInButton(testAvailability, new Object[][]{{"0", configuration}, {"1", configurationLoader}});
        }
        return selectedElement;
    }

    private static void injectDataInButton(Button button, Object[][] data) {
        int i = 0;
        while (i < data.length) {
            button.setData((String)data[i][0], data[i][1]);
            ++i;
        }
    }

    public static void handleDoubleClick(Button editOptions, SelectionListener listener) {
        if (!editOptions.isEnabled()) {
            return;
        }
        Event constructedEvent = new Event();
        constructedEvent.widget = editOptions;
        listener.widgetSelected(new SelectionEvent(constructedEvent));
    }

    public static IStatus checkValidity(ILaunchConfiguration conf, CheckboxTreeViewer checkBoxTreeViewer, ProfilingSetsManagerCopy profilingSetMgrCopy) {
        Object[] selection = checkBoxTreeViewer.getCheckedElements();
        boolean isValid = true;
        if (selection.length <= 0) {
            return new Status(4, "org.eclipse.hyades.trace.ui", LauncherMessages.ERROR_NO_DCM_SELECTED);
        }
        int i = 0;
        while (isValid && i < selection.length) {
            IStatus status;
            ILaunchValidator launchValidator = null;
            boolean parentChildNode = selection[i] instanceof DataCollectorTreeContentProvider.ParentChildNode;
            boolean agentTreeItem = selection[i] instanceof AttachAgentTabProviders.AgentTreeItem;
            DataCollectorAssociationData dcAssociationData = LauncherUtility.findDataCollectorAssociationData(conf, selection[i]);
            if (dcAssociationData != null) {
                launchValidator = dcAssociationData.getValidator();
            } else if (parentChildNode || agentTreeItem) {
                Object child;
                AttachAgentTabProviders.AgentTreeItem currentAgentTreeItem;
                AttachAgentTabProviders.AgentTreeItem agentTreeItem2 = currentAgentTreeItem = agentTreeItem ? (AttachAgentTabProviders.AgentTreeItem)selection[i] : null;
                Object object = parentChildNode ? ((DataCollectorTreeContentProvider.ParentChildNode)selection[i]).child : (child = currentAgentTreeItem.getAnalysisType() == null ? currentAgentTreeItem.getProfilingType() : currentAgentTreeItem.getAnalysisType());
                if (child instanceof AnalysisType) {
                    launchValidator = ((AnalysisType)child).getValidator();
                } else if (child instanceof ProfilingSetType) {
                    IProfilingType profilingType = ((ProfilingSetType)child).getProfilingType();
                    Control control = ProfileLaunchUtil.createProfilingTypeControls(profilingType, profilingSetMgrCopy);
                    String error = profilingType.validateConfiguration(profilingSetMgrCopy);
                    ProfileLaunchUtil.destroyControl(control);
                    if (error != null && error.length() > 0) {
                        return new Status(4, "org.eclipse.hyades.trace.ui", error);
                    }
                }
            }
            if (launchValidator != null && (status = launchValidator.validateConfiguration(conf)) != null && status.getSeverity() != 0) {
                return status;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static Control createProfilingTypeControls(IProfilingType profilingType, ProfilingSetsManagerCopy profilingSetMgrCopy) {
        Composite composite = new Composite((Composite)UIPlugin.getActiveWorkbenchShell(), 0);
        profilingType.createControl(composite, profilingSetMgrCopy);
        return composite;
    }

    public static void destroyControl(Control control) {
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
    }
}

