/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TraceProfileFiltersExtendedUI
extends TraceProfileFiltersUI {
    private Button _autoFilterBtn;

    public Composite createControl(Composite parent) {
        this._control = this.createParentControl(parent);
        this._autoFilterBtn = new Button(this._control, 32);
        this._autoFilterBtn.addSelectionListener((SelectionListener)this);
        this._autoFilterBtn.setText(UIPlugin.getResourceString(TraceMessages.FLT_AUTO));
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._autoFilterBtn.setLayoutData((Object)data);
        this.createVerticalIndent(this._control);
        this.createFilterSet(this._control);
        this.createFilterContents(this._control);
        this.createNoteLabel(this._control);
        return this._control;
    }

    protected void enableButtons() {
        if (this.isAgentTerminated()) {
            this._autoFilterBtn.setEnabled(false);
            this.enable(false);
            return;
        }
        super.enableButtons();
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._autoFilterBtn) {
            this.setAutoFilterCriteria(this._autoFilterBtn.getSelection());
        } else {
            super.widgetSelected(event);
        }
    }

    public void setAgentTerminated(boolean agentTerminated) {
        super.setAgentTerminated(agentTerminated);
        if (agentTerminated) {
            this._autoFilterBtn.setEnabled(false);
        }
    }

    public String getActiveFilterSet() {
        if (this.getAutoFilterCriteria()) {
            return "auto_generated_filter_set";
        }
        return super.getActiveFilterSet();
    }

    public FilterSetElement getActiveFilterSetElement() {
        return !this.getAutoFilterCriteria() ? super.getActiveFilterSetElement() : null;
    }

    public void setAutoFilterCriteria(boolean isAuto) {
        this._autoFilterBtn.setSelection(isAuto);
        boolean manualFilterCriteria = !this._autoFilterBtn.getSelection();
        this.enable(manualFilterCriteria);
        if (manualFilterCriteria) {
            this.enableButtons();
        }
    }

    public boolean getAutoFilterCriteria() {
        return this._autoFilterBtn.getSelection();
    }

    protected void showAutoGenFilterMessage(boolean enabled) {
        super.showAutoGenFilterMessage(enabled);
        if (enabled) {
            this._autoFilterBtn.setEnabled(false);
        } else {
            this._autoFilterBtn.setEnabled(true);
        }
    }
}

