/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.security.internal.util.IConnectUtilUI;
import org.eclipse.hyades.security.internal.util.NullConnectUtilUI;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ILaunchConfigurationTabUpdater;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileDestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.AgentControllerProbe;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.hyades.trace.ui.provisional.ITraceUIHelper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AvailabilityTesterDelegate;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeContentProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeLabelProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.EditOptionDelegate;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class TraceProfileUI
extends AbstractChangeable
implements ICheckStateListener,
ISelectionChangedListener,
KeyListener,
IDoubleClickListener,
ILaunchConfigurationTabUpdater {
    private static final int DATACOLLECTOR_TYPE = 0;
    private static final int ANALYSIS_TYPE = 1;
    private ProfileTab parentTab;
    private CheckboxTreeViewer checkBoxTreeViewer;
    private ILaunchConfiguration launchConfiguration;
    private ProfilingSetsManagerCopy profilingSetsManagerWC;
    private Button testAvailability;
    private Button editOptions;
    private String errorMessage;
    private boolean includeDestinationTab;
    private ProfileDestinationTab destinationTab;
    private Object selectedElement;
    private SelectionListener editOptionDelegate;
    private boolean initialized;
    private String lastHost;
    private int lastPort;
    private Job validateAcJob;
    private String lastVerifiedHost;
    private int lastVerifiedPort;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            TraceProfileUI.this.parentTab.update();
        }
    };

    public TraceProfileUI(ProfileTab parentTab, boolean includeDestinationTab) {
        this.parentTab = parentTab;
        this.includeDestinationTab = includeDestinationTab;
        if (includeDestinationTab) {
            this.destinationTab = new ProfileDestinationTab(parentTab);
        }
    }

    public Composite createControl(Composite parent) {
        if (this.includeDestinationTab) {
            return this.createNestedTabControl(parent);
        }
        return this.createFlatControl(parent);
    }

    private Composite createNestedTabControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        TabFolder folder = new TabFolder(parent, 128);
        TabItem item1 = new TabItem(folder, 128);
        item1.setText(UIPlugin.getResourceString(TraceMessages.TB_NVW));
        item1.setControl((Control)this.createFlatControl((Composite)folder));
        TabItem item2 = new TabItem(folder, 128);
        item2.setText(UIPlugin.getResourceString(TraceMessages.TB_NDEST));
        item2.setImage(PDPluginImages.getImage("folder.gif"));
        item2.setControl((Control)this.destinationTab.createControl((Composite)folder));
        this.destinationTab.addListener(this.listener);
        return folder;
    }

    private Composite createFlatControl(Composite parent) {
        Composite content = this.includeDestinationTab ? new Composite(parent, 0) : parent;
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        HyadesTraceUIExtensionSupportUtil.callExtensionUIElements(content, this.launchConfiguration, this.parentTab, HyadesTraceUIExtensionSupportUtil.TraceExtensionUIElementPos.TOP);
        Label launchLabel = new Label(content, 0);
        launchLabel.setText(TraceMessages.LAUNCH_INSTRUCTION);
        launchLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite treeComposite = new Composite(content, 0);
        treeComposite.setLayout((Layout)new GridLayout(2, false));
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDataCollectorTree(treeComposite);
        HyadesTraceUIExtensionSupportUtil.callExtensionUIElements(content, this.launchConfiguration, this.parentTab, HyadesTraceUIExtensionSupportUtil.TraceExtensionUIElementPos.BOTTOM);
        return content;
    }

    private void createDataCollectorTree(Composite treeComposite) {
        DataCollectorTreeContentProvider provider = new DataCollectorTreeContentProvider(this);
        this.checkBoxTreeViewer = new CheckboxTreeViewer(treeComposite);
        this.checkBoxTreeViewer.setContentProvider((IContentProvider)provider);
        this.checkBoxTreeViewer.setSorter(null);
        this.checkBoxTreeViewer.setLabelProvider((IBaseLabelProvider)new DataCollectorTreeLabelProvider());
        this.checkBoxTreeViewer.setInput(null);
        this.checkBoxTreeViewer.getTree().setLayout((Layout)new GridLayout());
        this.checkBoxTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.checkBoxTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.checkBoxTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.checkBoxTreeViewer.getTree().addKeyListener((KeyListener)this);
        this.checkBoxTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        Composite controlButtonComposite = new Composite(treeComposite, 0);
        controlButtonComposite.setLayout((Layout)new GridLayout());
        controlButtonComposite.setLayoutData((Object)new GridData(4, -1, false, false));
        this.editOptions = new Button(controlButtonComposite, 0);
        this.editOptions.setLayoutData((Object)new GridData(4, -1, false, false));
        this.editOptions.setText(TraceMessages.LAUNCH_CONTROL_EDIT);
        this.editOptionDelegate = EditOptionDelegate.getInstance(this, this.getProfilingSetWC());
        this.editOptions.addSelectionListener(this.editOptionDelegate);
        this.editOptions.setEnabled(false);
        this.testAvailability = new Button(controlButtonComposite, 0);
        this.testAvailability.setLayoutData((Object)new GridData(4, -1, false, false));
        this.testAvailability.setText(TraceMessages.LAUNCH_CONTROL_TEST);
        this.testAvailability.addSelectionListener((SelectionListener)AvailabilityTesterDelegate.getInstance());
        this.testAvailability.setEnabled(false);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object checkedElement = event.getElement();
        if (checkedElement instanceof DataCollector) {
            Object[] childrenOfSelectedItem;
            DataCollector selectedDatacollector = null;
            if (event.getChecked()) {
                selectedDatacollector = (DataCollector)checkedElement;
                this.deselectTreeItems(checkedElement, selectedDatacollector.getCoexistanceViolators(), 0);
                this.deselectIndirectViolators(checkedElement, 0);
            }
            this.checkBoxTreeViewer.setSelection((ISelection)new StructuredSelection(checkedElement));
            this.checkBoxTreeViewer.setGrayed(checkedElement, false);
            this.checkBoxTreeViewer.setSubtreeChecked(checkedElement, event.getChecked());
            if (selectedDatacollector != null && (childrenOfSelectedItem = ((DataCollectorTreeContentProvider)this.checkBoxTreeViewer.getContentProvider()).getChildren(selectedDatacollector)) != null) {
                int i = 0;
                while (i < childrenOfSelectedItem.length) {
                    if (childrenOfSelectedItem[i] instanceof DataCollectorTreeContentProvider.ParentChildNode && ((DataCollectorTreeContentProvider.ParentChildNode)childrenOfSelectedItem[i]).child instanceof AnalysisType) {
                        ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, childrenOfSelectedItem[i], true);
                        break;
                    }
                    ++i;
                }
            }
        } else if (checkedElement instanceof DataCollectorTreeContentProvider.ParentChildNode) {
            Object childNode;
            if (event.getChecked() && (childNode = ((DataCollectorTreeContentProvider.ParentChildNode)checkedElement).child) instanceof AnalysisType) {
                this.deselectTreeItems(checkedElement, ((AnalysisType)childNode).getCoexistanceViolators(), 1);
                this.deselectIndirectViolators(checkedElement, 1);
            }
            this.checkBoxTreeViewer.setSelection((ISelection)new StructuredSelection(checkedElement));
            Object parent = ((ITreeContentProvider)this.checkBoxTreeViewer.getContentProvider()).getParent(event.getElement());
            if (ProfileLaunchUtil.changeParentGrayState(this.checkBoxTreeViewer, event)) {
                this.deselectTreeItems(parent, ((DataCollector)parent).getCoexistanceViolators(), 0);
                this.deselectIndirectViolators(parent, 0);
            }
        }
        this.update();
    }

    private void deselectIndirectViolators(Object newlyCheckedElement, int itemType) {
        Object[] checkedElements = this.checkBoxTreeViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            Object childNode;
            Map violators = null;
            String currentItemId = null;
            if (itemType == 0 && !checkedElements[i].equals(newlyCheckedElement) && checkedElements[i] instanceof DataCollector) {
                violators = ((DataCollector)checkedElements[i]).getCoexistanceViolators();
                currentItemId = ((DataCollector)newlyCheckedElement).getId();
            } else if (itemType == 1 && !checkedElements[i].equals(newlyCheckedElement) && checkedElements[i] instanceof DataCollectorTreeContentProvider.ParentChildNode && (childNode = ((DataCollectorTreeContentProvider.ParentChildNode)checkedElements[i]).child) instanceof AnalysisType) {
                AnalysisType analysisType = (AnalysisType)childNode;
                violators = analysisType.getCoexistanceViolators();
                currentItemId = ((AnalysisType)((DataCollectorTreeContentProvider.ParentChildNode)newlyCheckedElement).child).getId();
            }
            if (violators != null && (violators.get(LauncherConstants.ALL) != null || violators.get(currentItemId) != null)) {
                ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, checkedElements[i], false);
            }
            ++i;
        }
    }

    private void deselectTreeItems(Object checkedElement, Map violators, int itemType) {
        if (violators == null || violators.size() <= 0) {
            return;
        }
        Object[] selectedItems = this.checkBoxTreeViewer.getCheckedElements();
        boolean deselectAll = violators.get(LauncherConstants.ALL) != null;
        int i = 0;
        while (i < selectedItems.length) {
            boolean isAnalysisTypeViolationPresent;
            Object childNode = null;
            boolean isDataCollectorViolationPresent = itemType == 0 && !selectedItems[i].equals(checkedElement) && selectedItems[i] instanceof DataCollector;
            boolean bl = isAnalysisTypeViolationPresent = itemType == 1 && !selectedItems[i].equals(checkedElement) && selectedItems[i] instanceof DataCollectorTreeContentProvider.ParentChildNode && (childNode = ((DataCollectorTreeContentProvider.ParentChildNode)selectedItems[i]).child) instanceof AnalysisType;
            if (!deselectAll) {
                isDataCollectorViolationPresent = isDataCollectorViolationPresent && (violators.get(((DataCollector)checkedElement).getId()) != null || violators.get(((DataCollector)selectedItems[i]).getId()) != null);
                boolean bl2 = isAnalysisTypeViolationPresent = isAnalysisTypeViolationPresent && (violators.get(((AnalysisType)((DataCollectorTreeContentProvider.ParentChildNode)checkedElement).child).getId()) != null || violators.get(((AnalysisType)childNode).getId()) != null);
            }
            if (isDataCollectorViolationPresent || isAnalysisTypeViolationPresent) {
                ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, selectedItems[i], false);
            }
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedElement = ProfileLaunchUtil.updateButtonStatus(this.launchConfiguration, event, this.editOptions, this.testAvailability, this.checkBoxTreeViewer, this);
    }

    public String getSelectedAnalysisType() {
        try {
            TreeSelection s = (TreeSelection)this.checkBoxTreeViewer.getSelection();
            DataCollectorTreeContentProvider.ParentChildNode p = (DataCollectorTreeContentProvider.ParentChildNode)s.getFirstElement();
            AnalysisType t = (AnalysisType)p.child;
            return t.getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setAnalysisType(String dataCollectorId, String analysisTypeId) {
        TreeItem[] dataCollectors = this.checkBoxTreeViewer.getTree().getItems();
        if (dataCollectors != null) {
            int i = 0;
            while (i < dataCollectors.length) {
                DataCollector dataCollector;
                if (dataCollectors[i].getData() instanceof DataCollector && (dataCollector = (DataCollector)dataCollectors[i].getData()).getId().equalsIgnoreCase(dataCollectorId)) {
                    AnalysisType[] analysisTypeArray = dataCollector.getApplicableAnalysisTypes();
                    int n = analysisTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnalysisType at = analysisTypeArray[n2];
                        if (at.getId().equalsIgnoreCase(analysisTypeId)) {
                            ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, new DataCollectorTreeContentProvider.ParentChildNode(dataCollector, at), true);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
    }

    public void initializeAfterFetch() {
        int i;
        if (this.checkBoxTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.getProfilingSetWC().initializeFrom(this.launchConfiguration);
        boolean isConfigurationNew = false;
        this.checkBoxTreeViewer.setAllChecked(false);
        Hashtable entitySelection = LauncherUtility.unserializeSelection(this.launchConfiguration);
        if (entitySelection == null) {
            isConfigurationNew = true;
        } else {
            for (DataCollector currentDataCollector : entitySelection.keySet()) {
                int chilrenCount;
                List selectedChildren = (List)entitySelection.get(currentDataCollector);
                int n = chilrenCount = selectedChildren == null ? 0 : selectedChildren.size();
                if (chilrenCount <= 0) {
                    ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, currentDataCollector, true);
                    continue;
                }
                i = 0;
                while (i < chilrenCount) {
                    ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, new DataCollectorTreeContentProvider.ParentChildNode(currentDataCollector, selectedChildren.get(i++)), true);
                }
            }
        }
        this.initialized = true;
        if (isConfigurationNew) {
            try {
                String profilingSetID;
                DataCollectorAssociation dataCollectorAssociator = DataCollectorManager.getInstance().getDataCollectorAssociator(this.launchConfiguration.getType().getIdentifier());
                String[] defaultDataCollectors = dataCollectorAssociator.getDefaultDataCollectors();
                if (defaultDataCollectors != null) {
                    int i2 = 0;
                    while (i2 < defaultDataCollectors.length) {
                        ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, DataCollectorManager.getInstance().getDataCollector(defaultDataCollectors[i2]), true);
                        ++i2;
                    }
                }
                TreeItem[] dataCollectors = this.checkBoxTreeViewer.getTree().getItems();
                boolean isPICollectorPresent = false;
                if (dataCollectors != null) {
                    i = 0;
                    while (i < dataCollectors.length) {
                        if (dataCollectors[i].getData() instanceof DataCollector) {
                            AnalysisType[] defaultAnalysisTypes;
                            DataCollector dataCollector = (DataCollector)dataCollectors[i].getData();
                            if ("org.eclipse.tptp.trace.ui.jvmpiMechanism".equals(dataCollector.getId())) {
                                isPICollectorPresent = true;
                            }
                            boolean isChecked = this.checkBoxTreeViewer.getChecked((Object)dataCollector);
                            boolean isGrayed = this.checkBoxTreeViewer.getGrayed((Object)dataCollector);
                            if ((!isChecked || isGrayed) && (defaultAnalysisTypes = dataCollector.getDefaultAnalysisTypes()) != null) {
                                int j = 0;
                                while (j < defaultAnalysisTypes.length) {
                                    ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, new DataCollectorTreeContentProvider.ParentChildNode(dataCollector, defaultAnalysisTypes[j]), true);
                                    ++j;
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (isPICollectorPresent && (profilingSetID = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, null)) != null) {
                    DataCollectorTreeContentProvider.ParentChildNode[] selectedItems = LauncherUtility.getSelectedDataCollectors(profilingSetID);
                    int i3 = 0;
                    while (i3 < selectedItems.length) {
                        ProfileLaunchUtil.changeItemCheckedState(this.checkBoxTreeViewer, this, selectedItems[i3++], true);
                    }
                }
                if (this.launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
                    this.performApply((ILaunchConfigurationWorkingCopy)this.launchConfiguration);
                }
            }
            catch (Exception e) {
                UIPlugin.getDefault().log(e);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        if (this.includeDestinationTab) {
            this.destinationTab.initializeFrom(conf);
        }
        this.launchConfiguration = conf;
        this.lazyUpdateDataCollectors(conf);
    }

    private void lazyUpdateDataCollectors(ILaunchConfiguration conf) {
        try {
            String currentHost = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int currentPort = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, CommonUIPlugin.getDefault().getPreferenceStore().getDefaultInt("localhost_port"));
            if (this.checkBoxTreeViewer.getInput() == null || this.lastHost == null || !this.lastHost.equals(currentHost) || this.lastPort != currentPort) {
                this.initialized = false;
                this.checkBoxTreeViewer.setInput((Object)new DataCollectorTreeContentProvider.DataCollectorTreeInput(conf));
                this.lastHost = currentHost;
                this.lastPort = currentPort;
            } else {
                this.initializeAfterFetch();
            }
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
    }

    public void lazyVerifyAC() {
        try {
            final String currentHost = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            final int currentPort = this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, CommonUIPlugin.getDefault().getPreferenceStore().getDefaultInt("localhost_port"));
            if (!(this.validateAcJob != null || this.lastVerifiedHost != null && this.lastVerifiedHost.equals(currentHost) && this.lastVerifiedPort == currentPort)) {
                this.lastVerifiedHost = currentHost;
                this.lastVerifiedPort = currentPort;
                this.validateAcJob = new Job(TraceMessages.TraceProfileUI_verifyACJobName){

                    public IStatus run(IProgressMonitor progress) {
                        int attempt = 0;
                        while (attempt < 15 && DataCollectorManager.getInstance().isFetching()) {
                            DataCollectorManager.getInstance().waitForDataCollectors(1000L);
                            ++attempt;
                        }
                        if (!ConnectUtil.isLocalHost((String)currentHost)) {
                            TraceProfileUI.this.validateAcJob = null;
                            return Status.OK_STATUS;
                        }
                        ITraceUIHelper traceUIHelper = ITraceUIHelper.INSTANCE;
                        IPreferenceStore store = traceUIHelper.getTraceUIPreferenceStore();
                        ConnectUtil util = new ConnectUtil(currentHost, "" + currentPort, store.getString("user_id"), traceUIHelper.getTraceUIApplication());
                        AgentControllerProbe acProbe = new AgentControllerProbe(util.getUserId(), traceUIHelper.getTraceUIApplication());
                        final AgentControllerProbe.Result res = acProbe.runProbe(currentHost, currentPort);
                        final IStatus status = res.legacyOnly ? new Status(2, "org.eclipse.hyades.trace.ui", "\n" + TraceMessages.TraceProfileUI_obsoleteDetail) : Status.OK_STATUS;
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                TraceProfileUI.this.validateAcJob = null;
                                if (!TraceProfileUI.this.parentTab.getControl().isDisposed()) {
                                    if (!status.isOK()) {
                                        ErrorDialog.openError((Shell)TraceProfileUI.this.parentTab.getControl().getShell(), (String)TraceMessages.CRD_CFWT, (String)NLS.bind((String)TraceMessages.TraceProfileUI_obsoleteAC, (Object)res.host, (Object)res.port), (IStatus)status);
                                    }
                                    TraceProfileUI.this.update();
                                }
                            }
                        });
                        return status;
                    }
                };
                this.validateAcJob.schedule();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy conf) {
        if (this.includeDestinationTab) {
            this.destinationTab.activated(conf);
        }
        try {
            String currentHost = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int currentPort = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, CommonUIPlugin.getDefault().getPreferenceStore().getDefaultInt("localhost_port"));
            Label label = null;
            ConnectUtil connect = new ConnectUtil(currentHost, "" + currentPort, ITraceUIHelper.INSTANCE.getTraceUIApplication());
            connect.setConnectionUI((IConnectUtilUI)new NullConnectUtilUI());
            Control[] controls = this.checkBoxTreeViewer.getTree().getParent().getParent().getChildren();
            int x = 0;
            while (x < controls.length) {
                if (controls[x] instanceof Label) {
                    label = (Label)controls[x];
                    break;
                }
                ++x;
            }
            int result = connect.connect(false);
            if (2 == result || 3 == result || 1 == result) {
                label.setForeground(new Color(null, 255, 0, 0));
                label.setText(TraceMessages.CONH_ERROR_);
                this.checkBoxTreeViewer.setInput(null);
                this.errorMessage = TraceMessages.CONH_ERROR_;
                return;
            }
            label.setForeground(new Color(null, 0, 0, 0));
            label.setText(TraceMessages.LAUNCH_INSTRUCTION);
            this.lazyUpdateDataCollectors((ILaunchConfiguration)conf);
            this.lazyVerifyAC();
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy wc) {
        this.initialized = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        if (!this.initialized) {
            return;
        }
        if (this.includeDestinationTab) {
            this.destinationTab.performApply(wc);
        }
        org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil.createDummyProfilingSet(this.getProfilingSetWC(), wc, this.checkBoxTreeViewer.getCheckedElements());
        String treeSelectionStr = LauncherUtility.serializeSelection(this.checkBoxTreeViewer);
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, treeSelectionStr);
    }

    public boolean isValid(ILaunchConfiguration conf) {
        if (this.includeDestinationTab && this.destinationTab.isValid(conf)) {
            return false;
        }
        if (this.validateAcJob != null && this.validateAcJob.getState() != 0) {
            this.errorMessage = TraceMessages.TraceProfileUI_verifyACStatus;
            return false;
        }
        IStatus status = ProfileLaunchUtil.checkValidity(conf, this.checkBoxTreeViewer, this.getProfilingSetWC());
        this.errorMessage = status.isOK() ? null : status.getMessage();
        return status.isOK();
    }

    public ProfilingSetsManagerCopy getProfilingSetWC() {
        if (this.profilingSetsManagerWC == null) {
            this.profilingSetsManagerWC = new ProfilingSetsManagerCopy();
        }
        return this.profilingSetsManagerWC;
    }

    public void update() {
        this.parentTab.update();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode != 0x100000B || this.selectedElement == null) {
            return;
        }
        String descriptionContent = null;
        Object child = null;
        if (this.selectedElement instanceof DataCollector) {
            descriptionContent = ((DataCollector)this.selectedElement).getDescription();
        } else if (this.selectedElement instanceof DataCollectorTreeContentProvider.ParentChildNode) {
            child = ((DataCollectorTreeContentProvider.ParentChildNode)this.selectedElement).child;
            if (child instanceof AnalysisType) {
                descriptionContent = ((AnalysisType)child).getDescription();
            } else if (child instanceof IProfilingSetType) {
                descriptionContent = ((IProfilingSetType)child).getDescription();
            }
        }
        if (descriptionContent == null || descriptionContent.length() <= 0) {
            return;
        }
        Display display = UIPlugin.getDefault().getWorkbench().getDisplay();
        final Shell quickDescShell = new Shell(display.getActiveShell(), 16);
        Color color = new Color((Device)display, 251, 253, 213);
        quickDescShell.setLayout((Layout)new GridLayout());
        quickDescShell.setLayoutData((Object)new GridData());
        quickDescShell.setLocation(display.getCursorLocation());
        quickDescShell.setSize(200, 100);
        quickDescShell.setBackground(color);
        Text descTxt = new Text((Composite)quickDescShell, 64);
        descTxt.setLayoutData((Object)new GridData(4, 4, true, true));
        descTxt.setBackground(color);
        descTxt.setText(descriptionContent);
        descTxt.setEditable(false);
        quickDescShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                if (quickDescShell != null && !quickDescShell.isDisposed()) {
                    quickDescShell.close();
                    quickDescShell.dispose();
                }
            }
        });
        quickDescShell.open();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void doubleClick(DoubleClickEvent event) {
        ProfileLaunchUtil.handleDoubleClick(this.editOptions, this.editOptionDelegate);
    }

    public CheckboxTreeViewer getCheckBoxTreeViewer() {
        return this.checkBoxTreeViewer;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }
}

