/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachAgentsTab;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.core.NodeFactory;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerPool;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AgentDeclaration;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AgentDeclarationManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class AttachAgentTabProviders {

    public static class AgentTreeInput
    implements IAdaptable {
        private DeferredAgentAdapter deferredAgentAdapter;
        private ILaunchConfiguration configuration;

        public AgentTreeInput(ILaunchConfiguration configuration, AttachAgentsTab agentsTab) {
            this.deferredAgentAdapter = new DeferredAgentAdapter(configuration, agentsTab);
            this.configuration = configuration;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IDeferredWorkbenchAdapter.class) {
                return this.deferredAgentAdapter;
            }
            return null;
        }

        public ILaunchConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(ILaunchConfiguration configuration) {
            this.configuration = configuration;
        }
    }

    public static class AgentTreeItem {
        private AgentTreeItem parent;
        private DataCollector dataCollector;
        private Agent agent;
        private IAgent newAgent;
        private AnalysisType analysisType;
        private IProfilingSetType profilingType;

        public AgentTreeItem(DataCollector dataCollector, Agent agent) {
            this.dataCollector = dataCollector;
            this.agent = agent;
        }

        public AgentTreeItem(DataCollector dataCollector, IAgent newAgent) {
            this.dataCollector = dataCollector;
            this.newAgent = newAgent;
        }

        public AgentTreeItem(AgentTreeItem parent, AnalysisType analysisType) {
            this.parent = parent;
            this.analysisType = analysisType;
        }

        public AgentTreeItem(AgentTreeItem parent, IProfilingSetType profilingType) {
            this.parent = parent;
            this.profilingType = profilingType;
        }

        public boolean hasChildren() {
            return this.dataCollector != null;
        }

        public AgentTreeItem getParent() {
            return this.parent;
        }

        public Agent getAgent() {
            return this.agent;
        }

        public DataCollector getDataCollector() {
            return this.dataCollector;
        }

        public AnalysisType getAnalysisType() {
            return this.analysisType;
        }

        public IAgent getNewAgent() {
            return this.newAgent;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AgentTreeItem)) {
                return false;
            }
            AgentTreeItem item = (AgentTreeItem)o;
            String itemProcessId = null;
            String processId = null;
            itemProcessId = item.getProcessId();
            processId = this.getProcessId();
            if (processId == null) {
                processId = "";
            }
            return processId.equals(itemProcessId) && this.equalCheck(this.parent, item.getParent()) && this.equalCheck(this.agent, item.getAgent()) && this.equalCheck(this.newAgent, item.getNewAgent()) && this.equalCheck(item);
        }

        private boolean equalCheck(AgentTreeItem parent1, AgentTreeItem parent2) {
            if (parent1 == null) {
                return parent2 == null;
            }
            return parent1.equals(parent2);
        }

        private boolean equalCheck(AgentTreeItem item) {
            if (this.dataCollector != null) {
                DataCollector itemDataCollector = item.getDataCollector();
                return itemDataCollector != null && this.dataCollector.getId().equals(itemDataCollector.getId());
            }
            if (this.analysisType != null) {
                AnalysisType itemAnalysisType = item.getAnalysisType();
                return itemAnalysisType != null && this.analysisType.getId().equals(itemAnalysisType.getId());
            }
            if (this.profilingType != null) {
                IProfilingSetType itemProfilingType = item.getProfilingType();
                return itemProfilingType != null && this.profilingType.getId().equals(itemProfilingType.getId());
            }
            return item.getDataCollector() == null && item.getAnalysisType() == null && item.getProfilingType() == null;
        }

        private boolean equalCheck(IAgent newAgent1, IAgent newAgent2) {
            if (newAgent1 == null) {
                return newAgent2 == null;
            }
            if (newAgent2 == null) {
                return false;
            }
            return this.newAgent.getName() == null ? newAgent2.getName() == null : this.newAgent.getName().equals(newAgent2.getName());
        }

        private boolean equalCheck(Agent agent1, Agent agent2) {
            if (agent1 == null) {
                return agent2 == null;
            }
            if (agent2 == null) {
                return false;
            }
            return agent1.getName() == null ? agent2.getName() == null : (agent1.getName().equals(agent2.getName()) && agent1.getType() == null ? agent2.getType() == null : agent1.getType().equals(agent2.getType()));
        }

        public String getProcessId() {
            try {
                return this.agent == null ? (this.newAgent == null ? "" : String.valueOf(this.newAgent.getProcess().getProcessId())) : this.agent.getProcess().getProcessId();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean isNew() {
            return this.newAgent != null;
        }

        public IProfilingSetType getProfilingType() {
            return this.profilingType;
        }

        public void setProfilingType(IProfilingSetType profilingType) {
            this.profilingType = profilingType;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.dataCollector == null ? "" : this.dataCollector.getId()).append(this.analysisType == null ? "" : this.analysisType.getId()).append(this.profilingType == null ? "" : this.profilingType.getId());
            return sb.toString();
        }
    }

    public static class AttachAgentContentProvider
    implements ITreeContentProvider {
        private DeferredTreeContentManager deferredContentManager;
        private AttachAgentsTab agentsTab;
        private TreeViewer treeViewer;
        private AgentTreeInput input;

        public AttachAgentContentProvider(TreeViewer treeViewer, AttachAgentsTab agentsTab) {
            this.treeViewer = treeViewer;
            this.agentsTab = agentsTab;
        }

        public Object[] getChildren(Object parentElement) {
            AgentTreeItem agentTreeItem = null;
            DataCollector dataCollector = null;
            if (parentElement instanceof AgentTreeItem && (dataCollector = (agentTreeItem = (AgentTreeItem)parentElement).getDataCollector()) != null) {
                AnalysisType[] analysisTypes = dataCollector.getApplicableAnalysisTypes();
                ArrayList<AgentTreeItem> items = new ArrayList<AgentTreeItem>(analysisTypes.length);
                int i = 0;
                while (i < analysisTypes.length) {
                    ICollectorFiltration filter = analysisTypes[i].getFilter();
                    if (filter == null || filter.include(analysisTypes[i].getId(), this.input == null ? null : this.input.getConfiguration(), agentTreeItem.getAgent() == null ? agentTreeItem.getNewAgent() : agentTreeItem.getAgent())) {
                        items.add(new AgentTreeItem(agentTreeItem, analysisTypes[i]));
                    }
                    ++i;
                }
                if ("org.eclipse.tptp.trace.ui.jvmpiMechanism".equals(dataCollector.getId())) {
                    Object[] profilingTypes = ProfilingSetsManager.instance().getProfilingTypes().values().toArray();
                    int i2 = 0;
                    while (i2 < profilingTypes.length) {
                        if (!(profilingTypes[i2] instanceof AnalysisType) && profilingTypes[i2] instanceof IProfilingSetType) {
                            items.add(new AgentTreeItem(agentTreeItem, (IProfilingSetType)profilingTypes[i2]));
                        }
                        ++i2;
                    }
                }
                return items.toArray(new AgentTreeItem[items.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AgentTreeItem) {
                return ((AgentTreeItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AgentTreeItem) {
                return ((AgentTreeItem)element).hasChildren();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.deferredContentManager.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            AgentTreeInput agentTreeInput = this.input = newInput instanceof AgentTreeInput ? (AgentTreeInput)newInput : null;
            if (this.deferredContentManager != null) {
                return;
            }
            this.deferredContentManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer){

                protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
                    WorkbenchJob updateJob = new WorkbenchJob(TraceMessages.AttachAdding){

                        public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                            if (AttachAgentContentProvider.this.treeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            AttachAgentContentProvider.this.treeViewer.add(parent, children);
                            return Status.OK_STATUS;
                        }
                    };
                    updateJob.setSystem(true);
                    updateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            AttachAgentContentProvider.this.agentsTab.initializeAfterFetch();
                        }
                    });
                    updateJob.schedule();
                }
            };
        }
    }

    public static class AttachAgentLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof AgentTreeItem) {
                AgentTreeItem item = (AgentTreeItem)element;
                String processId = " [PID: " + item.getProcessId() + "]";
                if (item.getDataCollector() != null) {
                    return String.valueOf(item.getDataCollector().getName()) + processId;
                }
                if (item.getAnalysisType() != null) {
                    return item.getAnalysisType().getName();
                }
                if (item.getProfilingType() != null) {
                    return item.getProfilingType().getName();
                }
                Agent agent = item.getAgent();
                IAgent newAgent = item.getNewAgent();
                if (agent != null && agent.getName() != null) {
                    return String.valueOf(agent.getName()) + processId;
                }
                if (newAgent != null && newAgent.getName() != null) {
                    return String.valueOf(newAgent.getName()) + processId;
                }
            } else {
                if (element instanceof PendingUpdateAdapter) {
                    return TraceMessages.AttachPendingElement;
                }
                if (element instanceof MessageTreeItem) {
                    MessageTreeItem messageTreeItem = (MessageTreeItem)element;
                    return messageTreeItem.getMessage();
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            MessageTreeItem messageTreeItem;
            if (element instanceof AgentTreeItem) {
                AgentTreeItem item = (AgentTreeItem)element;
                if (item.getDataCollector() != null) {
                    return item.getDataCollector().getIcon().createImage();
                }
                if (item.getAnalysisType() != null) {
                    return item.getAnalysisType().getIcon().createImage();
                }
                if (item.getProfilingType() != null) {
                    return item.getProfilingType().getImage().createImage();
                }
                return TraceUIImages.INSTANCE.getImage("c", "detachAgent.gif");
            }
            if (element instanceof MessageTreeItem && (messageTreeItem = (MessageTreeItem)element).getSeverity() == 4) {
                return PDPluginImages.getImage("error_tsk.gif");
            }
            return super.getImage(element);
        }
    }

    public static class DeferredAgentAdapter
    implements IDeferredWorkbenchAdapter {
        private ILaunchConfiguration configuration;
        private DataCollectorAssociation dataCollectorAssociations;
        private AttachAgentsTab agentsTab;

        public DeferredAgentAdapter(ILaunchConfiguration configuration, AttachAgentsTab agentsTab) {
            this.configuration = configuration;
            this.agentsTab = agentsTab;
        }

        /*
         * Unable to fully structure code
         */
        public void fetchDeferredChildren(Object parent, IElementCollector collector, IProgressMonitor monitor) {
            block20: {
                if (!(parent instanceof AgentTreeInput)) break block20;
                node = null;
                try {
                    block19: {
                        hostname = this.configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
                        port = this.configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, -1);
                        monitor.beginTask(TraceMessages.AttachRetrievingAgents, 5);
                        node = PDCoreUtil.profileConnect((String)hostname, (String)String.valueOf(port), (boolean)false);
                        if (node == null) {
                            return;
                        }
                        monitor.worked(1);
                        processes = node.listProcesses();
                        if (processes == null) {
                            return;
                        }
                        monitor.worked(1);
                        items = new AgentTreeItem[]{};
                        while (processes.hasMoreElements()) {
                            process = (Process)processes.nextElement();
                            agents = process.listAgents();
                            if (agents != null) ** GOTO lbl25
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                agent = (Agent)agents.nextElement();
                                if (agent.isAttached()) continue;
                                items = this.determineDataCollectorMapping(agent);
                                collector.add(items, monitor);
lbl25:
                                // 3 sources

                                ** while (agents.hasMoreElements())
                            }
lbl26:
                            // 1 sources

                        }
                        monitor.worked(1);
                        if (port >= 0) break block19;
                        return;
                    }
                    try {
                        try {
                            ac = AgentControllerPool.getInstance().getConnection(hostname, port);
                            NodeFactory.createNode((String)hostname);
                            monitor.worked(1);
                            runningAgents = ac.queryRunningAgents();
                            i = 0;
                            while (i < runningAgents.length) {
                                if (!runningAgents[i].isMonitored()) {
                                    items = this.determineDataCollectorMapping(runningAgents[i]);
                                    collector.add(items, monitor);
                                }
                                ++i;
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            collector.add((Object)new MessageTreeItem(TraceMessages.AttachAttachErrorRetrievingAgents, 4), monitor);
                            UIPlugin.getDefault().log(e);
                        }
                    }
                    catch (CoreException e) {
                        collector.add((Object)new MessageTreeItem(TraceMessages.AttachAttachErrorFindingHostInfo, 4), monitor);
                        UIPlugin.getDefault().log(e);
                    }
                    catch (NotConnectedException e) {
                        collector.add((Object)new MessageTreeItem(TraceMessages.CONH_ERROR_, 4), monitor);
                        UIPlugin.getDefault().log(e);
                    }
                }
                finally {
                    monitor.done();
                    collector.done();
                }
            }
        }

        private AgentTreeItem[] determineDataCollectorMapping(Object agent) {
            ArrayList<AgentTreeItem> mappedDataCollectors = new ArrayList<AgentTreeItem>();
            Agent oldAgent = null;
            IAgent newAgent = null;
            if (agent instanceof Agent) {
                oldAgent = (Agent)agent;
            } else if (agent instanceof IAgent) {
                newAgent = (IAgent)agent;
            } else {
                return new AgentTreeItem[0];
            }
            try {
                if (this.dataCollectorAssociations == null) {
                    this.dataCollectorAssociations = DataCollectorManager.getInstance().getDataCollectorAssociator(this.configuration.getType().getIdentifier());
                }
                DataCollector[] dataCollectors = this.dataCollectorAssociations.getDataCollectors();
                int i = 0;
                while (i < dataCollectors.length) {
                    DataCollectorAssociationData associationData = this.dataCollectorAssociations.getDataCollectorAssociationData(dataCollectors[i].getId());
                    String[] applicableAgents = associationData.getApplicableAgents();
                    int j = 0;
                    while (j < applicableAgents.length) {
                        boolean matched;
                        AgentDeclaration agentDeclaration = AgentDeclarationManager.getInstance().getAgentDeclaration(applicableAgents[j]);
                        boolean bl = oldAgent == null ? agentDeclaration.getName().equals(newAgent.getName()) : (matched = ("*".equals(agentDeclaration.getName()) || agentDeclaration.getName().equals(oldAgent.getName())) && agentDeclaration.getType().equals(oldAgent.getType()));
                        if (matched) {
                            AgentTreeItem agentTreeItem = oldAgent == null ? new AgentTreeItem(dataCollectors[i], newAgent) : new AgentTreeItem(dataCollectors[i], oldAgent);
                            mappedDataCollectors.add(agentTreeItem);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (mappedDataCollectors.size() <= 0 && oldAgent != null) {
                    AgentTreeItem agentTreeItem = new AgentTreeItem(null, oldAgent);
                    mappedDataCollectors.add(agentTreeItem);
                }
            }
            catch (CoreException e) {
                UIPlugin.getDefault().log(e);
            }
            return mappedDataCollectors.toArray(new AgentTreeItem[mappedDataCollectors.size()]);
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return TraceMessages.AttachAttachHost;
        }

        public Object getParent(Object child) {
            if (child instanceof AgentTreeItem) {
                return ((AgentTreeItem)child).getParent();
            }
            return null;
        }
    }

    public static class MessageTreeItem {
        private String message;
        private int severity;

        public MessageTreeItem(String message, int severity) {
            this.message = message;
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }
    }
}

