/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachAgentTabProviders;
import org.eclipse.hyades.trace.ui.internal.launcher.ILaunchConfigurationTabUpdater;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.SelectedAgent;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.EditOptionDelegate;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage;

public class AttachAgentsTab
extends AbstractLaunchConfigurationTab
implements ICheckStateListener,
ISelectionChangedListener,
IDoubleClickListener,
SelectionListener,
ILaunchConfigurationTabUpdater {
    private CheckboxTreeViewer agentsCheckBoxTree;
    private Button editOptions;
    private SelectionListener editOptionDelegate;
    private ILaunchConfiguration configuration;
    private boolean initialized;
    private String errorMessage;
    private boolean enableValidation = true;
    private ProfilingSetsManagerCopy profilingSetsManagerWC;

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        this.setControl((Control)content);
        this.createVerticalSpacer(content, 1);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label agentsLabel = new Label(content, 0);
        GridData agentsLabelGD = new GridData(4, -1, true, false);
        agentsLabelGD.horizontalIndent = 10;
        agentsLabel.setLayoutData((Object)agentsLabelGD);
        agentsLabel.setText(TraceMessages.LST_AG);
        Composite treeComposite = new Composite(content, 0);
        treeComposite.setLayout((Layout)new GridLayout(2, false));
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.agentsCheckBoxTree = new CheckboxTreeViewer(treeComposite);
        this.agentsCheckBoxTree.setContentProvider((IContentProvider)new AttachAgentTabProviders.AttachAgentContentProvider((TreeViewer)this.agentsCheckBoxTree, this));
        this.agentsCheckBoxTree.setSorter(null);
        this.agentsCheckBoxTree.setLabelProvider((IBaseLabelProvider)new AttachAgentTabProviders.AttachAgentLabelProvider());
        this.agentsCheckBoxTree.setInput(null);
        this.agentsCheckBoxTree.getTree().setLayout((Layout)new GridLayout());
        this.agentsCheckBoxTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.agentsCheckBoxTree.addCheckStateListener((ICheckStateListener)this);
        this.agentsCheckBoxTree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.agentsCheckBoxTree.addDoubleClickListener((IDoubleClickListener)this);
        Composite buttonComposite = new Composite(treeComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData(-1, 128, false, true));
        this.editOptions = this.createButton(buttonComposite, TraceMessages.LAUNCH_CONTROL_EDIT, null);
        this.editOptionDelegate = EditOptionDelegate.getInstance(this, this.getProfilingSetWC());
        this.editOptions.setEnabled(false);
        this.editOptions.addSelectionListener(this.editOptionDelegate);
        this.createButton(buttonComposite, TraceMessages.AttachRefresh, this);
    }

    private Button createButton(Composite parent, String text, SelectionListener listener) {
        Button button = new Button(parent, 0);
        GridData buttonGD = new GridData(4, -1, true, false);
        buttonGD.widthHint = 100;
        button.setLayoutData((Object)buttonGD);
        button.setText(text);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public String getName() {
        return TraceMessages.TB_NAGENT;
    }

    public Image getImage() {
        return PDPluginImages.getImage("agent_obj.gif");
    }

    public ProfilingSetsManagerCopy getProfilingSetWC() {
        if (this.profilingSetsManagerWC == null) {
            this.profilingSetsManagerWC = new ProfilingSetsManagerCopy();
        }
        return this.profilingSetsManagerWC;
    }

    public void initializeAfterFetch() {
        try {
            AttachAgentTabProviders.AgentTreeItem item;
            SelectedAgent[] selectedAgents = LauncherUtility.retrieveSelectedAgents(this.configuration);
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.agentsCheckBoxTree.getContentProvider();
            Tree tree = this.agentsCheckBoxTree.getTree();
            if (tree.isDisposed()) {
                return;
            }
            TreeItem[] treeElements = tree.getItems();
            Hashtable<String, AttachAgentTabProviders.AgentTreeItem> availableAgents = new Hashtable<String, AttachAgentTabProviders.AgentTreeItem>();
            int i = 0;
            while (i < treeElements.length) {
                if (treeElements[i].getData() instanceof AttachAgentTabProviders.AgentTreeItem) {
                    item = (AttachAgentTabProviders.AgentTreeItem)treeElements[i].getData();
                    availableAgents.put(item.getProcessId(), item);
                }
                ++i;
            }
            i = 0;
            while (i < selectedAgents.length) {
                item = (AttachAgentTabProviders.AgentTreeItem)availableAgents.get(selectedAgents[i].getPid());
                if (item != null && (item.getDataCollector() == null || selectedAgents[i].getCollectorId().equals(item.getDataCollector().getId()))) {
                    String[] analysisTypes = selectedAgents[i].getAnalysisTypes();
                    if (analysisTypes == null || analysisTypes.length <= 0) {
                        this.agentsCheckBoxTree.setChecked((Object)item, true);
                    } else {
                        Object[] availableAnalysisTypes = contentProvider.getChildren((Object)item);
                        int j = 0;
                        while (j < availableAnalysisTypes.length) {
                            int k = 0;
                            while (k < analysisTypes.length) {
                                AttachAgentTabProviders.AgentTreeItem currentItem = (AttachAgentTabProviders.AgentTreeItem)availableAnalysisTypes[j];
                                String id = "";
                                if (currentItem.getAnalysisType() != null) {
                                    id = currentItem.getAnalysisType().getId();
                                } else if (currentItem.getProfilingType() != null) {
                                    id = currentItem.getProfilingType().getId();
                                }
                                if (id.equals(analysisTypes[k]) && !this.agentsCheckBoxTree.getChecked(availableAnalysisTypes[j])) {
                                    org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.changeItemCheckedState(this.agentsCheckBoxTree, this, availableAnalysisTypes[j], true);
                                }
                                ++k;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
        this.initialized = true;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.configuration == null || !this.configuration.equals(configuration)) {
            this.configuration = configuration;
            this.agentsCheckBoxTree.setInput((Object)new AttachAgentTabProviders.AgentTreeInput(configuration, this));
            this.initialized = false;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!this.initialized) {
            return;
        }
        Object[] checkedElements = this.agentsCheckBoxTree.getCheckedElements();
        String selectionSerailized = "";
        int i = 0;
        while (i < checkedElements.length) {
            if (checkedElements[i] instanceof AttachAgentTabProviders.AgentTreeItem) {
                boolean profilingTypePresent;
                AttachAgentTabProviders.AgentTreeItem agentTreeItem = (AttachAgentTabProviders.AgentTreeItem)checkedElements[i];
                boolean analysisTypePresent = agentTreeItem.getAnalysisType() != null;
                boolean bl = profilingTypePresent = agentTreeItem.getProfilingType() != null;
                if (!analysisTypePresent && !profilingTypePresent) {
                    String dataCollectorID;
                    if (selectionSerailized.length() > 0) {
                        selectionSerailized = String.valueOf(selectionSerailized) + ";";
                    }
                    String processId = agentTreeItem.getProcessId();
                    String string = dataCollectorID = agentTreeItem.getDataCollector() == null ? " " : agentTreeItem.getDataCollector().getId();
                    if (dataCollectorID.equals(" ") && !agentTreeItem.isNew() && agentTreeItem.getAgent() instanceof Agent && agentTreeItem.getAgent().getType().equals("Profiler")) {
                        dataCollectorID = "org.eclipse.tptp.trace.ui.jvmpiMechanism";
                    }
                    selectionSerailized = String.valueOf(selectionSerailized) + processId + ":" + (agentTreeItem.isNew() ? agentTreeItem.getNewAgent().getName() : agentTreeItem.getAgent().getName()) + ":" + dataCollectorID + ":";
                } else {
                    selectionSerailized = String.valueOf(selectionSerailized) + (analysisTypePresent ? agentTreeItem.getAnalysisType().getId() : agentTreeItem.getProfilingType().getId()) + ",";
                }
            }
            ++i;
        }
        configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, selectionSerailized);
        ProfileLaunchUtil.createDummyProfilingSet(this.getProfilingSetWC(), configuration, this.agentsCheckBoxTree.getCheckedElements());
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initialized = false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean profilingTypeSelection;
        if (!(event.getElement() instanceof AttachAgentTabProviders.AgentTreeItem)) {
            return;
        }
        AttachAgentTabProviders.AgentTreeItem item = (AttachAgentTabProviders.AgentTreeItem)event.getElement();
        this.agentsCheckBoxTree.setSelection((ISelection)new StructuredSelection((Object)item));
        boolean analysisTypeSelection = item.getAnalysisType() != null;
        boolean bl = profilingTypeSelection = item.getProfilingType() != null;
        if (item.getDataCollector() != null) {
            if (event.getChecked()) {
                ITreeContentProvider provider = (ITreeContentProvider)this.agentsCheckBoxTree.getContentProvider();
                Object[] children = provider.getChildren((Object)item);
                if (children != null) {
                    this.enableValidation = false;
                    int i = children.length - 1;
                    while (i >= 0) {
                        org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.changeItemCheckedState(this.agentsCheckBoxTree, this, children[i], true);
                        --i;
                    }
                    this.enableValidation = true;
                }
            } else {
                this.agentsCheckBoxTree.setSubtreeChecked((Object)item, false);
            }
        } else if (analysisTypeSelection || profilingTypeSelection) {
            if (event.getChecked()) {
                if (analysisTypeSelection) {
                    this.updateViolators(this.agentsCheckBoxTree, event);
                }
                try {
                    DataCollectorAssociation association = DataCollectorManager.getInstance().getDataCollectorAssociator(this.configuration.getType().getIdentifier());
                    DataCollectorAssociationData associationData = association.getDataCollectorAssociationData(item.getParent().getDataCollector().getId());
                    LightConfigurationLoader[] configs = new LightConfigurationLoader[analysisTypeSelection ? 2 : 1];
                    configs[0] = associationData.getConfigurationLoader();
                    if (analysisTypeSelection) {
                        configs[1] = item.getAnalysisType().getConfigurationLoader();
                        int i = 0;
                        while (i < configs.length) {
                            if (configs[i] != null && configs[i].isEditable()) {
                                IConfiguration configuration = (IConfiguration)configs[i].getConfigurationClass();
                                IConfigurationPage[] pages = configuration.getConfigurationPages();
                                int j = 0;
                                while (j < pages.length) {
                                    pages[j].reset(this.configuration);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    UIPlugin.getDefault().log(e);
                }
            }
            org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.changeParentGrayState(this.agentsCheckBoxTree, event);
        }
        this.update();
    }

    private void updateViolators(CheckboxTreeViewer treeViewer, CheckStateChangedEvent event) {
        AttachAgentTabProviders.AgentTreeItem selectedItem = (AttachAgentTabProviders.AgentTreeItem)event.getElement();
        ITreeContentProvider contentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        Object parent = contentProvider.getParent((Object)selectedItem);
        Object[] children = contentProvider.getChildren(parent);
        Map violators = selectedItem.getAnalysisType().getCoexistanceViolators();
        if (violators == null) {
            return;
        }
        String selectedAnalysisTypeId = selectedItem.getAnalysisType().getId();
        ArrayList<Object> selectedSibilings = new ArrayList<Object>();
        Object[] selectedItems = treeViewer.getCheckedElements();
        int i = 0;
        while (i < selectedItems.length) {
            int j = 0;
            while (j < children.length) {
                if (selectedItems[i].equals(children[j])) {
                    selectedSibilings.add(children[j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        int selectedSibilingCount = selectedSibilings.size();
        while (i < selectedSibilingCount) {
            AttachAgentTabProviders.AgentTreeItem item = (AttachAgentTabProviders.AgentTreeItem)selectedSibilings.get(i);
            AnalysisType analysisType = item.getAnalysisType();
            if (analysisType != null && (violators.get(LauncherConstants.ALL) != null || violators.get(analysisType.getId()) != null || analysisType.getCoexistanceViolators().get(selectedAnalysisTypeId) != null)) {
                treeViewer.setChecked((Object)item, false);
            }
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.updateButtonStatus(this.configuration, event, this.editOptions, null, this.agentsCheckBoxTree, this);
    }

    public void doubleClick(DoubleClickEvent event) {
        org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.handleDoubleClick(this.editOptions, this.editOptionDelegate);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.agentsCheckBoxTree.refresh();
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!this.enableValidation) {
            return true;
        }
        IStatus status = org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.checkValidity(launchConfig, this.agentsCheckBoxTree, this.getProfilingSetWC());
        this.errorMessage = status.isOK() ? null : status.getMessage();
        return status.isOK();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public CheckboxTreeViewer getAgentsCheckBoxTree() {
        return this.agentsCheckBoxTree;
    }
}

