/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.RunAttachProfileStatusHandler;
import org.eclipse.hyades.trace.ui.internal.launcher.SelectedAgent;
import org.eclipse.hyades.trace.ui.internal.util.AttachConfigurationDetail;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerPool;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisTypeManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.AgentSelection;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentAttach;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILightConfiguration;

public class AttachDelegate
implements ILaunchConfigurationDelegate {
    public void launch(final ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Map launchDelegates = null;
        try {
            List selectedAgents = AttachDelegate.retrieveSelectedAgents(conf);
            monitor.worked(1);
            if (selectedAgents.size() <= 0 || !this.unattachedAgents(selectedAgents)) {
                monitor.setCanceled(true);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = UIPlugin.getActiveWorkbenchShell();
                        DebugUITools.openLaunchConfigurationDialog((Shell)shell, (ILaunchConfiguration)conf, (String)"org.eclipse.debug.ui.launchGroup.profile", (IStatus)new Status(0, UIPlugin.getPluginId(), RunAttachProfileStatusHandler.CODE, "", null));
                    }
                });
                return;
            }
            monitor.beginTask(LauncherMessages.LAUNCHING_BEGIN_TASK, selectedAgents == null ? 4 : selectedAgents.size() + 4);
            ArrayList launchDelegateList = new ArrayList();
            launchDelegates = this.findLaunchDelegates(conf, selectedAgents, launchDelegateList);
            LauncherUtility.delegateInit(launchDelegateList, conf, mode, launch, monitor);
            monitor.subTask(TraceMessages.LNCH_MSGV);
            monitor.worked(1);
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(conf);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            this.attachToAgents(selectedAgents, launchDelegates, conf, launch);
            this.postLaunch(launchDelegates, Status.OK_STATUS);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            this.postLaunch(launchDelegates, (IStatus)new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            throw e;
        }
    }

    private void attachToAgents(List selectedAgents, Map launchDelegates, ILaunchConfiguration conf, ILaunch launch) {
        try {
            Vector<IAgent> agents = new Vector<IAgent>();
            int i = 0;
            int selectedAgentCount = selectedAgents.size();
            while (i < selectedAgentCount) {
                SelectedAgent agentSelection = (SelectedAgent)selectedAgents.get(i);
                agents.add((IAgent)(agentSelection.getAgent() == null ? agentSelection.getNewAgent() : agentSelection.getAgent()));
                ++i;
            }
            Vector options = this.retrieveOptions(selectedAgents, conf);
            AttachConfigurationDetail configurationDetail = new AttachConfigurationDetail(conf, launch);
            configurationDetail.setSwitchPerspective(true);
            configurationDetail.setOptions(options);
            configurationDetail.setAgents(agents);
            Vector attachedAgents = PDCoreUtil.attach(configurationDetail);
            if (attachedAgents.size() != agents.size()) {
                LauncherUtility.createCoreException(4, LauncherMessages.AttachErrorAttaching);
            }
            ArrayList<AgentSelection> agentSelection = new ArrayList<AgentSelection>();
            int i2 = 0;
            int agentCount = attachedAgents.size();
            while (i2 < agentCount) {
                AgentSelection selection = new AgentSelection();
                selection.setAgent(agents.get(i2));
                selection.setAgentProxy((TRCAgentProxy)attachedAgents.get(i2));
                agentSelection.add(selection);
                ++i2;
            }
            this.associateAnalysisTypes(attachedAgents, selectedAgents);
            if (launchDelegates == null) {
                return;
            }
            for (String agentName : launchDelegates.keySet()) {
                ArrayList<AgentSelection> applicableAgents = new ArrayList<AgentSelection>();
                int i3 = 0;
                int agentSelectionCount = agentSelection.size();
                while (i3 < agentSelectionCount) {
                    String type;
                    AgentSelection selection = (AgentSelection)agentSelection.get(i3);
                    String string = type = selection.getAgent() instanceof Agent ? ((Agent)selection.getAgent()).getType() : "";
                    if (agentName.equals(String.valueOf(selection.getAgentProxy().getName()) + type)) {
                        applicableAgents.add(selection);
                    }
                    ++i3;
                }
                IDataCollectorAgentAttach launchDelegate = (IDataCollectorAgentAttach)launchDelegates.get(agentName);
                launchDelegate.launch(applicableAgents.toArray(new AgentSelection[applicableAgents.size()]));
            }
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
    }

    private Vector retrieveOptions(List selectedAgents, ILaunchConfiguration config) {
        Vector options = new Vector();
        this.addAttributes(options, LauncherUtility.getDefaultProfilingOptionsAttributes());
        try {
            int i = 0;
            int selectedAgentCount = selectedAgents.size();
            while (i < selectedAgentCount) {
                SelectedAgent agentSelection = (SelectedAgent)selectedAgents.get(i);
                if (agentSelection.getCollectorId() != null) {
                    String[] analysisTypeIds;
                    DataCollectorAssociation associator = DataCollectorManager.getInstance().getDataCollectorAssociator(config.getType().getIdentifier());
                    if (agentSelection.getCollectorId().length() > 0) {
                        LightConfigurationLoader configLoader = associator.getDataCollectorAssociationData(agentSelection.getCollectorId()).getConfigurationLoader();
                        this.addAttributes(options, configLoader, config);
                    }
                    if ((analysisTypeIds = agentSelection.getAnalysisTypes()) != null) {
                        int j = 0;
                        while (j < analysisTypeIds.length) {
                            AnalysisType analysisType = AnalysisTypeManager.getInstance().getAnalysisType(analysisTypeIds[j]);
                            if (analysisType != null) {
                                LightConfigurationLoader configLoader = analysisType.getConfigurationLoader();
                                this.addAttributes(options, configLoader, config);
                            } else {
                                Vector profilingSetOptions = ProfilingSetsManager.instance().getOptions(config);
                                ProfilingAttribute[] attributes = new ProfilingAttribute[profilingSetOptions.size()];
                                int k = 0;
                                while (k < attributes.length) {
                                    AgentConfigurationEntry entry = (AgentConfigurationEntry)profilingSetOptions.get(k);
                                    attributes[k] = new ProfilingAttribute(entry.getName(), entry.getValue());
                                    ++k;
                                }
                                this.addAttributes(options, attributes);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
        return options;
    }

    private void addAttributes(Vector options, LightConfigurationLoader configLoader, ILaunchConfiguration configuration) {
        ProfilingAttribute[] attributes;
        if (configLoader == null) {
            return;
        }
        ILightConfiguration lightConfiguration = configLoader.getConfigurationClass();
        if (lightConfiguration instanceof IConfiguration) {
            IConfigurationPage[] pages = ((IConfiguration)lightConfiguration).getConfigurationPages();
            int i = 0;
            while (i < pages.length) {
                pages[i].reset(configuration);
                ++i;
            }
        }
        if ((attributes = lightConfiguration.getAttributes()) == null) {
            return;
        }
        this.addAttributes(options, attributes);
    }

    private void addAttributes(Vector options, ProfilingAttribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getValue() != null) {
                boolean foundOption = false;
                String attributeName = attributes[i].getName();
                boolean option = attributeName.startsWith("SETOPTION_");
                boolean filter = attributeName.startsWith("SETFILTER");
                boolean methodFilter = attributeName.startsWith("SETMETHODFILTER");
                attributeName = option ? attributeName.substring("SETOPTION_".length()) : (filter ? attributeName.substring("SETFILTER".length()) : (methodFilter ? attributeName.substring("SETMETHODFILTER".length()) : attributeName));
                int j = 0;
                int optionCount = options.size();
                while (j < optionCount) {
                    AgentConfigurationEntry pOption = (AgentConfigurationEntry)options.get(j);
                    if (pOption.getName().equals(attributeName)) {
                        if (pOption.getValue().equals("false")) {
                            pOption.setValue(attributes[i].getValue());
                        } else if (pOption.getValue().equals("none")) {
                            pOption.setValue(attributes[i].getValue());
                        } else {
                            if (attributes[i].getValue().equals("false")) {
                                return;
                            }
                            if (pOption.getValue().equals("none")) {
                                return;
                            }
                            if (pOption.getName().equals("STACK_INFORMATION")) {
                                if (pOption.getValue().equals("boundary")) {
                                    return;
                                }
                                if (!attributes[i].getValue().equals("none")) {
                                    pOption.setValue(attributes[i].getValue());
                                }
                            } else if (pOption.getName().equals("TRACE_MODE") && pOption.getValue().equals("noObjectCorrelation")) {
                                pOption.setValue(attributes[i].getValue());
                            }
                        }
                        foundOption = true;
                        break;
                    }
                    ++j;
                }
                if (!foundOption) {
                    AgentConfigurationEntry entry = new AgentConfigurationEntry();
                    entry.setName(attributeName);
                    entry.setValue(attributes[i].getValue());
                    entry.setType(filter ? "SETFILTER" : (methodFilter ? "SETMETHODFILTER" : "SETOPTION"));
                    options.add(entry);
                }
            }
            ++i;
        }
    }

    private void associateAnalysisTypes(List attachedAgents, List selectedAgents) {
        if (attachedAgents.size() != selectedAgents.size()) {
            return;
        }
        int i = 0;
        int attachedAgentCount = attachedAgents.size();
        while (i < attachedAgentCount) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)attachedAgents.get(i);
            SelectedAgent agentSelection = (SelectedAgent)selectedAgents.get(i);
            String[] analysisTypes = agentSelection.getAnalysisTypes();
            if (analysisTypes != null) {
                TRCConfiguration configuration = HierarchyFactory.eINSTANCE.createTRCConfiguration();
                configuration.setActive(true);
                configuration.setAgentProxy(agentProxy);
                configuration.setName("SETOPTION");
                int j = 0;
                while (j < analysisTypes.length) {
                    TRCOption option = HierarchyFactory.eINSTANCE.createTRCOption();
                    option.setConfiguration(configuration);
                    AgentConfigurationEntry confEntry = LauncherUtility.associateAnalysisType(null, analysisTypes[j]);
                    option.setKey(confEntry.getName());
                    option.setValue(confEntry.getValue());
                    ++j;
                }
            }
            ++i;
        }
    }

    private Map findLaunchDelegates(ILaunchConfiguration conf, List selectedAgents, List launchDelegateList) {
        Hashtable<String, IDataCollectorBaseLauncher> launchDelegates = new Hashtable<String, IDataCollectorBaseLauncher>();
        try {
            int i = 0;
            int selectedAgentsCount = selectedAgents.size();
            while (i < selectedAgentsCount) {
                SelectedAgent agentSelection = (SelectedAgent)selectedAgents.get(i);
                String dataCollectorId = agentSelection.getCollectorId();
                IDataCollectorBaseLauncher delegate = DataCollectorManager.getInstance().getDataCollectorLaunchDelegate(dataCollectorId, conf);
                if (delegate != null) {
                    launchDelegateList.add(delegate);
                    if (delegate.isMutualLauncher()) {
                        launchDelegates.put(String.valueOf(agentSelection.getAgentName()) + (agentSelection.getAgent() == null ? "" : agentSelection.getAgent().getType()), delegate);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return launchDelegates;
    }

    private boolean unattachedAgents(List agents) {
        if (agents != null) {
            int i = 0;
            int agentCount = agents.size();
            while (i < agentCount) {
                SelectedAgent agentSelection = (SelectedAgent)agents.get(i);
                if (agentSelection.getAgent() != null && !agentSelection.getAgent().isAttached() || agentSelection.getNewAgent() != null && !agentSelection.getNewAgent().isMonitored()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void postLaunch(Map launchDelegates, IStatus status) throws CoreException {
        if (launchDelegates != null) {
            Iterator delegates = launchDelegates.values().iterator();
            while (delegates.hasNext()) {
                ((IDataCollectorMutualLauncher)delegates.next()).postLaunch(status);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Process retrieveProcess(ILaunchConfiguration conf, String processID, boolean showErrorMsgs) {
        if (processID == null) return null;
        if (conf == null) {
            return null;
        }
        try {
            Process p;
            IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
            String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt("localhost_port"));
            Enumeration enum1 = PDCoreUtil.getNodeConfiguration(host, port, showErrorMsgs);
            if (enum1 == null) {
                return null;
            }
            do {
                if (enum1.hasMoreElements()) continue;
                return null;
            } while (!(p = (Process)enum1.nextElement()).getProcessId().equals(processID));
            return p;
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
        }
        return null;
    }

    protected static IAgent retrieveIAgent(ILaunchConfiguration conf, String processID, SelectedAgent agentSelection) {
        if (processID == null || conf == null) {
            return null;
        }
        try {
            IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
            String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt("localhost_port"));
            IAgentController ac = AgentControllerPool.getInstance().getConnection(host, port);
            IAgent[] runningAgents = ac.queryRunningAgents();
            if (runningAgents != null) {
                int i = 0;
                while (i < runningAgents.length) {
                    IAgent agent = runningAgents[i];
                    String pId = String.valueOf(agent.getProcess().getProcessId());
                    String name = runningAgents[i].getName();
                    if (pId.equals(processID) && name.equals(agentSelection.getAgentName())) {
                        return agent;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Map retrieveProcesses(ILaunchConfiguration conf, boolean showErrorMsgs) {
        store = CommonUIPlugin.getDefault().getPreferenceStore();
        processes = new Hashtable<String, Object>();
        try {
            host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt("localhost_port"));
            enum1 = PDCoreUtil.getNodeConfiguration(host, port, showErrorMsgs);
            if (enum1 == null) {
                return null;
            }
            while (true) {
                block6: {
                    if (enum1.hasMoreElements()) break block6;
                    ac = AgentControllerPool.getInstance().getConnection(host, port);
                    runningAgents = ac.queryRunningAgents();
                    if (runningAgents == null) return processes;
                    i = 0;
                    if (true) ** GOTO lbl29
                }
                process = (Process)enum1.nextElement();
                processes.put(process.getProcessId(), process);
            }
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
        }
        return processes;
        do {
            if (processes.get(processId = String.valueOf((process = runningAgents[i].getProcess()).getProcessId())) == null) {
                processes.put(processId, process);
            }
            ++i;
lbl29:
            // 2 sources

        } while (i < runningAgents.length);
        return processes;
    }

    protected static Map retrieveProcesses(ILaunchConfiguration conf) {
        Map processes = AttachDelegate.retrieveProcesses(conf, true);
        return processes;
    }

    public static List retrieveSelectedAgents(ILaunchConfiguration conf) {
        try {
            String agents = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, "");
            if (agents.length() <= 0) {
                return new ArrayList();
            }
            StringTokenizer st = new StringTokenizer(agents, ";");
            ArrayList<SelectedAgent> agentSelections = new ArrayList<SelectedAgent>();
            while (st.hasMoreTokens()) {
                agentSelections.add(new SelectedAgent(st.nextToken()));
            }
            int i = 0;
            int agentSelectionsCount = agentSelections.size();
            while (i < agentSelectionsCount) {
                SelectedAgent agentSelection = (SelectedAgent)agentSelections.get(i);
                Process p = AttachDelegate.retrieveProcess(conf, agentSelection.getPid(), true);
                IAgent iA = AttachDelegate.retrieveIAgent(conf, agentSelection.getPid(), agentSelection);
                if (p != null) {
                    Agent agent = p.getAgent(agentSelection.getAgentName());
                    if (agent != null) {
                        agentSelection.setAgent(agent);
                    } else if (iA != null) {
                        agentSelection.setNewAgent(iA);
                    }
                } else if (iA != null) {
                    agentSelection.setNewAgent(iA);
                }
                ++i;
            }
            return agentSelections;
        }
        catch (Exception e) {
            CommonPlugin.logError((Throwable)e);
            return new ArrayList();
        }
    }

    public static Map createMap(List list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SelectedAgent agentAttribute : list) {
            Vector<String> agents = (Vector<String>)map.get(agentAttribute.getPid());
            if (agents == null) {
                agents = new Vector<String>();
            }
            agents.addElement(agentAttribute.getAgentName());
            map.put(agentAttribute.getPid(), agents);
        }
        Iterator keys = map.keySet().iterator();
        String key = null;
        Vector agents = null;
        String[] stringArray = null;
        while (keys.hasNext()) {
            key = (String)keys.next();
            agents = (Vector)map.get(key);
            stringArray = new String[agents.size()];
            agents.toArray(stringArray);
            map.put(key, stringArray);
        }
        return map;
    }
}

