/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DestinationTab
extends AbstractLaunchConfigurationTab {
    private TraceLocationUI destinationUI = new TraceLocationUI();
    private TraceFileUI fileUI = new TraceFileUI();

    public DestinationTab() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                DestinationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.destinationUI.addListener(listener);
        this.fileUI.addListener(listener);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this.destinationUI.createControl(content);
        this.fileUI.createControl(content);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String location = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, "");
            String monitor = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, "");
            String file = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, "");
            boolean profileToFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
            if (location.length() == 0) {
                location = store.getString("prj_name");
            }
            if (monitor.length() == 0) {
                monitor = store.getString("mon_name");
            }
            this.destinationUI.setLocation(location);
            this.destinationUI.setMonitor(monitor);
            this.fileUI.setFile(file);
            this.fileUI.setEnabled(profileToFile);
            this.fileUI.getExternalBox().setSelection(profileToFile);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, this.destinationUI.getLocation().getText().trim());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, this.destinationUI.getMonitor().getText().trim());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, this.fileUI.getExternalBox().getSelection());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, this.fileUI.getFile());
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.destinationUI.getLocation().getText().trim().length() == 0) {
            this.setErrorMessage(TraceMessages.TAB_ERRDP);
            return false;
        }
        if (this.destinationUI.getMonitor().getText().trim().length() == 0) {
            this.setErrorMessage(TraceMessages.TAB_ERRDM);
            return false;
        }
        if (this.fileUI.getSelection() && this.fileUI.getFile().trim().length() == 0) {
            this.setErrorMessage(TraceMessages.TAB_ERRDF);
            return false;
        }
        if (this.fileUI.getSelection() && this.fileUI.getFile().trim().length() > 0) {
            String fName = this.fileUI.getFile().trim();
            String dirName = this.getDirectoryName(fName);
            String fileName = this.getFileName(fName);
            if (!new File(dirName).exists()) {
                this.setErrorMessage(TraceMessages.TAB_ERRDR);
                return false;
            }
            if (fileName.equals("") || fileName.length() == 0) {
                this.setErrorMessage(TraceMessages.TAB_ERRDR);
                return false;
            }
            if (new File(fName).isDirectory()) {
                this.setErrorMessage(TraceMessages.TAB_ERRDR);
                return false;
            }
        }
        return true;
    }

    public String getName() {
        return TraceMessages.TB_NDEST;
    }

    public Image getImage() {
        return PDPluginImages.getImage("folder.gif");
    }

    private String getDirectoryName(String fName) {
        int i = fName.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            fName = fName.substring(0, i);
        }
        return fName;
    }

    private String getFileName(String fName) {
        int i = fName.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            fName = fName.substring(i + 1);
        }
        return fName;
    }
}

