/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachAgentTabProviders;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeContentProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILightConfiguration;

public class ProfileLaunchUtil {
    private static final String[] EMPTY = new String[0];

    public static String[] getEnvironmentVariables(ILaunchConfiguration conf) throws CoreException {
        Map envMap = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        if (envMap != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : envMap.keySet()) {
                list.add(String.valueOf(key) + "=" + envMap.get(key));
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
        return EMPTY;
    }

    public static boolean performProfilingTypesLaunch(ILaunchConfiguration config) {
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        IProfilingSet set = null;
        try {
            String setID = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, null);
            set = (IProfilingSet)manager.getProfilingSets().get(setID);
        }
        catch (CoreException e) {
            CommonPlugin.logError((Throwable)e);
        }
        if (set == null) {
            return true;
        }
        IProfilingSetType[] profilingTypes = new IProfilingSetType[manager.getProfilingTypes().size()];
        profilingTypes = manager.getProfilingTypes().values().toArray(profilingTypes);
        List types = set.getProfilingTypes();
        int i = 0;
        while (i < profilingTypes.length) {
            IProfilingType type;
            String msg;
            if (types.contains(profilingTypes[i].getId()) && (msg = (type = profilingTypes[i].getProfilingType()).launch(config)) != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)msg);
                    }
                });
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertToDelimitedString(String[] array, char delimiter) {
        return ProfileLaunchUtil.convertToDelimitedString(array, delimiter, true);
    }

    public static String convertToDelimitedString(String[] array, char delimiter, boolean addQuotes) {
        StringBuffer buf = new StringBuffer();
        if (array.length > 0) {
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    buf.append(delimiter);
                }
                if (array[i].startsWith("\"") && array[i].endsWith("\"")) {
                    buf.append(array[i]);
                } else if (!addQuotes || array[i].indexOf(32) == -1) {
                    buf.append(array[i]);
                } else {
                    buf.append('\"');
                    buf.append(array[i]);
                    buf.append('\"');
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public static void createDummyProfilingSet(ProfilingSetsManagerCopy profilingSetManager, ILaunchConfigurationWorkingCopy wc, Object[] selectedElements) {
        List optionsList = null;
        String configurationName = wc.getName();
        ProfileLaunchUtil.cleanProfilingSets(profilingSetManager, configurationName);
        String dummyProfilingSetID = "tptp-dummy-profiling-set-" + configurationName;
        ProfilingSet dummyProfilingSet = (ProfilingSet)profilingSetManager.getProfilingSets().get(dummyProfilingSetID);
        if (dummyProfilingSet == null) {
            dummyProfilingSet = new ProfilingSet(dummyProfilingSetID, "DummyProfilingSet", "Programmatically Created");
        }
        dummyProfilingSet.getProfilingTypes().clear();
        optionsList = LauncherUtility.getDefaultProfilingOptions();
        Hashtable<String, Boolean> addedAttributes = new Hashtable<String, Boolean>();
        ArrayList<IConfiguration> configurations = new ArrayList<IConfiguration>();
        DataCollectorTreeContentProvider.ParentChildNode currentParentChildItem = null;
        AttachAgentTabProviders.AgentTreeItem currentAgentTreeItem = null;
        int i = 0;
        while (i < selectedElements.length) {
            block22: {
                int j;
                Object childNode;
                block21: {
                    block20: {
                        if (!(selectedElements[i] instanceof DataCollectorTreeContentProvider.ParentChildNode)) break block20;
                        currentParentChildItem = (DataCollectorTreeContentProvider.ParentChildNode)selectedElements[i];
                        break block21;
                    }
                    if (!(selectedElements[i] instanceof AttachAgentTabProviders.AgentTreeItem)) break block22;
                    currentAgentTreeItem = (AttachAgentTabProviders.AgentTreeItem)selectedElements[i];
                }
                Object object = currentAgentTreeItem == null ? currentParentChildItem.child : (childNode = currentAgentTreeItem.getAnalysisType() == null ? currentAgentTreeItem.getProfilingType() : currentAgentTreeItem.getAnalysisType());
                if (childNode instanceof AnalysisType) {
                    ILightConfiguration lightConfigClass;
                    AnalysisType analysisType = (AnalysisType)childNode;
                    dummyProfilingSet.getProfilingTypes().add(analysisType.getId());
                    LightConfigurationLoader lightConfigurationLoader = analysisType.getConfigurationLoader();
                    if (lightConfigurationLoader != null && (lightConfigClass = lightConfigurationLoader.getConfigurationClass()) != null) {
                        DataCollectionEngineAttribute[] attributes;
                        if (lightConfigurationLoader.isEditable()) {
                            IConfiguration configuration = (IConfiguration)lightConfigClass;
                            IConfigurationPage[] configurationPages = configuration.getConfigurationPages();
                            configurations.add(configuration);
                            j = 0;
                            while (j < configurationPages.length) {
                                configurationPages[j++].reset(wc.getOriginal());
                            }
                        }
                        if ((attributes = lightConfigClass.getAttributes()) != null) {
                            int j2 = 0;
                            while (j2 < attributes.length) {
                                optionsList.add(attributes[j2]);
                                addedAttributes.put(attributes[j2].getName(), Boolean.TRUE);
                                ++j2;
                            }
                        }
                    }
                } else if (childNode instanceof IProfilingSetType) {
                    IProfilingSetType profilingSetType = (IProfilingSetType)childNode;
                    dummyProfilingSet.getProfilingTypes().add(profilingSetType.getId());
                    IProfilingType profilingType = profilingSetType.getProfilingType();
                    Control control = null;
                    ProfilingAttribute[] attributes = null;
                    try {
                        attributes = profilingType.getAttributes();
                    }
                    catch (Exception exception) {
                        control = org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.createProfilingTypeControls(profilingType, profilingSetManager);
                        attributes = profilingType.getAttributes();
                    }
                    j = 0;
                    while (j < attributes.length) {
                        attributes[j].setContributorId(profilingSetType.getId());
                        optionsList.add(attributes[j]);
                        addedAttributes.put(attributes[j].getName(), Boolean.TRUE);
                        ++j;
                    }
                    if (control != null) {
                        org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil.destroyControl(control);
                    }
                }
            }
            ++i;
        }
        Map currentAttributes = dummyProfilingSet.getAttributes();
        Object[] keys = currentAttributes.keySet().toArray();
        int i2 = 0;
        while (i2 < keys.length) {
            Object currentKey = keys[i2];
            if (addedAttributes.get(currentKey) == null) {
                currentAttributes.remove(currentKey);
            }
            ++i2;
        }
        optionsList = LauncherUtility.filterDuplicateOptions(optionsList);
        profilingSetManager.getProfilingSets().put(dummyProfilingSetID, dummyProfilingSet);
        profilingSetManager.setDefaultSet(dummyProfilingSet);
        Map attrs = dummyProfilingSet.getAttributes();
        for (ProfilingAttribute profilingAttribute : attrs.values()) {
            profilingAttribute.setEnabled(false);
        }
        int idx = 0;
        while (idx < optionsList.size()) {
            ProfilingAttribute option = (ProfilingAttribute)optionsList.get(idx);
            attrs.put(option.getName(), option);
            ++idx;
        }
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, dummyProfilingSetID);
        profilingSetManager.applyManagerChanges();
        profilingSetManager.writeProfilingSetsToPreference();
    }

    private static void cleanProfilingSets(ProfilingSetsManagerCopy profilingSetManager, String configurationName) {
        Map profilingSets = profilingSetManager.getProfilingSets();
        Object[] profilingSetIds = profilingSets.keySet().toArray();
        Hashtable<String, ILaunchConfiguration> launchConfigurationsMap = new Hashtable<String, ILaunchConfiguration>();
        int dummyPSLength = "tptp-dummy-profiling-set-".length();
        try {
            ILaunchConfiguration[] launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int i = 0;
            while (i < launchConfigurations.length) {
                launchConfigurationsMap.put(launchConfigurations[i].getName(), launchConfigurations[i]);
                ++i;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        int i = 0;
        while (i < profilingSetIds.length) {
            String profilingSetId = (String)profilingSetIds[i];
            if (profilingSetId.startsWith("tptp-dummy-profiling-set-") && !profilingSetId.equals("tptp-dummy-profiling-set-" + configurationName) && launchConfigurationsMap.get(profilingSetId.substring(dummyPSLength)) == null) {
                profilingSets.remove(profilingSetId);
            }
            ++i;
        }
    }
}

