/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentPeerListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ProfileUIManager;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AttachConfigurationDetail;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.ILauncherHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.StatGeneratorDataProcessor;

public class PIProcessListener
implements ProcessListener,
AgentPeerListener {
    protected ArrayList _monitoredAgents = new ArrayList();
    protected ArrayList _processVariableList = new ArrayList();
    protected TRCNode fNode;
    protected TRCProcessProxy fProcess;
    protected boolean _autoMonitoring = true;
    protected boolean _monitor = false;
    protected int _launchMode = 0;
    private ArrayList filteredAgentList;
    protected static final String getLauncherHandlersExtPoint = "launcherHandler";
    private static Map launcherHandlers;
    private StatGeneratorDataProcessor fdataProcessor;

    public PIProcessListener(TRCNode node) {
        this.fNode = node;
    }

    public PIProcessListener(TRCNode node, TRCProcessProxy process) {
        this(node);
        this.fProcess = process;
    }

    public void setAutoMonitoring(boolean b) {
        this._autoMonitoring = b;
    }

    public void setLaunchMode(int mode) {
        this._launchMode = mode;
    }

    public ArrayList getProcessVariableList() {
        return this._processVariableList;
    }

    public StatGeneratorDataProcessor getDataProcessor() {
        return this.fdataProcessor;
    }

    public synchronized void agentActive(Agent ag) {
        if (this.fProcess == null) {
            return;
        }
        if (this._monitoredAgents.contains(ag.getName())) {
            this._monitor = false;
        } else {
            this._monitoredAgents.add(ag.getName());
        }
        if (!this._monitor) {
            return;
        }
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent((TRCProcessProxy)this.fProcess, (Agent)ag, (boolean)false);
        if (agentProxy == null) {
            return;
        }
        agentProxy.setRuntimeId(ag.getUUID());
        LoadersUtils.registerAgentInstance((TRCAgentProxy)agentProxy, (Object)ag);
        agentProxy.setAttached(true);
        agentProxy.setProfileFile(ag.getProfileFile());
        this.giveControl(agentProxy, true, true);
        if (agentProxy.isActive()) {
            final TRCAgentProxy agentTemp = agentProxy;
            Display d = Display.getDefault();
            d.asyncExec(new Runnable(){

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)agentTemp);
                    event.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            return;
        }
        agentProxy.setActive(true);
        try {
            ag.publishConfiguration();
            CustomCommand applyFilterCommand = new CustomCommand();
            CustomCommand resumeCommand = new CustomCommand();
            applyFilterCommand.setData("APPLYFILTERS");
            ag.invokeCustomCommand(applyFilterCommand);
            this.fdataProcessor = (StatGeneratorDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agentProxy);
            if (this.fdataProcessor == null) {
                this.fdataProcessor = new StatGeneratorDataProcessor(agentProxy);
                LoadersUtils.registerDataProcessor((TRCAgentProxy)agentProxy, (XMLLoader)this.fdataProcessor);
            }
            if (agentProxy.isToProfileFile()) {
                this.fdataProcessor.setProfileFileName(agentProxy.getProfileFile());
                this.fdataProcessor.createWriter();
                if (this.fdataProcessor.isNewProfileFile()) {
                    this.fdataProcessor.writeXMLVersion(this.fdataProcessor.getWriter());
                    this.fdataProcessor.startTrace(this.fdataProcessor.getWriter());
                }
            }
            agentProxy.setAttached(true);
            if (this._autoMonitoring) {
                ag.startMonitoring((DataProcessor)this.fdataProcessor);
                agentProxy.setMonitored(true);
            }
            agentProxy.setCollectionData(true);
            resumeCommand.setData("RESUME");
            ag.invokeCustomCommand(resumeCommand);
            this.giveControl(agentProxy, false, true);
        }
        catch (InactiveAgentException exc) {
            exc.printStackTrace();
        }
        final TRCAgentProxy agentTemp = agentProxy;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)agentTemp);
                event.setType(1);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    public synchronized void agentInactive(Agent ag) {
        if (this.fProcess == null) {
            return;
        }
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent((TRCProcessProxy)this.fProcess, (Agent)ag, (boolean)true);
        if (agentProxy == null) {
            return;
        }
        agentProxy.setActive(false);
        agentProxy.setAttached(false);
        agentProxy.setMonitored(false);
        this.fProcess.setActive(false);
        this.giveControl(agentProxy, true, false);
        final TRCAgentProxy agentTemp = agentProxy;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)agentTemp);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    protected void giveControl(TRCAgentProxy agentProxy, boolean pre, boolean active) {
        if (launcherHandlers == null) {
            this.initializeLauncherHandlers();
        }
        Object[] launcherHandlersArray = launcherHandlers.values().toArray();
        int num = 0;
        while (num < launcherHandlersArray.length) {
            block8: {
                ILauncherHandler type = (ILauncherHandler)launcherHandlersArray[num];
                try {
                    if (active) {
                        if (pre) {
                            type.handlePreAgentActive(agentProxy);
                        } else {
                            type.handlePostAgentActive(agentProxy);
                        }
                    } else {
                        type.handleAgentInactive(agentProxy);
                    }
                }
                catch (Exception e) {
                    if (e.getMessage() == null) break block8;
                    Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            ++num;
        }
    }

    protected void giveControl(TRCProcessProxy processProxy, boolean launched) {
        if (launcherHandlers == null) {
            this.initializeLauncherHandlers();
        }
        Object[] launcherHandlersArray = launcherHandlers.values().toArray();
        int num = 0;
        while (num < launcherHandlersArray.length) {
            block6: {
                ILauncherHandler type = (ILauncherHandler)launcherHandlersArray[num];
                try {
                    if (launched) {
                        type.handleProcessLaunched(processProxy);
                    } else {
                        type.handleProcessExited(processProxy);
                    }
                }
                catch (Exception e) {
                    if (e.getMessage() == null) break block6;
                    Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            ++num;
        }
    }

    private void initializeLauncherHandlers() {
        launcherHandlers = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.trace.ui", getLauncherHandlersExtPoint);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                ILauncherHandler getControlType = null;
                try {
                    getControlType = (ILauncherHandler)elem.createExecutableExtension("class");
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    e.printStackTrace();
                }
                if (getControlType != null) {
                    launcherHandlers.put(id, getControlType);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        this._monitoredAgents.clear();
        this.fNode = null;
        this.fProcess = null;
        this._processVariableList.clear();
    }

    public void error(Agent agent, String errorId, String errStr) {
        final String errorMsg = errStr;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                Status err = new Status(2, "org.eclipse.core.resources", 566, errorMsg, null);
                ErrorDialog.openError((Shell)new Shell(), (String)TraceMessages.LJP_ERROR_, (String)TraceMessages.PB_AC_WARN_, (IStatus)err);
            }
        });
    }

    public void handleCommand(Agent agent, CommandElement command) {
    }

    public void monitor(boolean monitor) {
        this._monitor = monitor;
        this._monitoredAgents.clear();
    }

    public synchronized void peerWaiting(Agent agent, Agent peer) {
        if (!peer.isAttached() && this.fProcess != null && this.fNode != null) {
            TRCMonitor trcMonitor;
            TRCNode trcNode;
            TRCProcessProxy trcProcess;
            TRCAgentProxy trcAgent = null;
            for (TRCAgentProxy agentProxy : this.fProcess.getAgentProxies()) {
                Object obj = LoadersUtils.locateAgentInstance((TRCAgentProxy)agentProxy);
                if (obj != agent) continue;
                trcAgent = agentProxy;
                break;
            }
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String projectName = store.getString("prj_name");
            String monitorName = store.getString("mon_name");
            String profileFile = agent != null ? agent.getProfileFile() : null;
            String peerProfileFile = null;
            if (profileFile != null) {
                StringBuffer suffix = new StringBuffer().append("_").append(trcAgent.getProcessProxy().getNode().getName()).append("_").append(trcAgent.getProcessProxy().getPid()).append("_").append(trcAgent.getRuntimeId()).append(".trcxml");
                int ext = profileFile.lastIndexOf(".trcxml");
                peerProfileFile = ext > 0 ? new StringBuffer(profileFile.substring(0, ext)).append(suffix).toString() : new StringBuffer(profileFile).append(suffix).toString();
            }
            if (trcAgent != null && (trcProcess = trcAgent.getProcessProxy()) != null && (trcNode = trcProcess.getNode()) != null && (trcMonitor = trcNode.getMonitor()) != null) {
                URI projectPath = trcMonitor.eResource().getURI();
                String fullProjectPath = projectPath.trimSegments(1).path();
                fullProjectPath = fullProjectPath.substring(fullProjectPath.indexOf(47, 1));
                if ((fullProjectPath = fullProjectPath.replaceAll("%20", " ")) != null) {
                    monitorName = trcMonitor.getName();
                    projectName = fullProjectPath;
                }
            }
            try {
                Node node = peer.getProcess().getNode();
                String hostname = node.getName();
                String port = String.valueOf(node.getConnection().getPort());
                Vector<Agent> agents = new Vector<Agent>();
                agents.add(peer);
                Vector<AgentConfigurationEntry> options = new Vector<AgentConfigurationEntry>();
                AgentConfiguration conf = agent.getConfiguration();
                int i = 0;
                while (i < conf.size()) {
                    options.add(conf.getEntryAt(i));
                    ++i;
                }
                PDCoreUtil.profileConnect((String)hostname, (String)port);
                AttachConfigurationDetail attachConfigurationDetail = new AttachConfigurationDetail();
                attachConfigurationDetail.setHostName(hostname);
                attachConfigurationDetail.setAgents(agents);
                attachConfigurationDetail.setOptions(options);
                attachConfigurationDetail.setProject(projectName);
                attachConfigurationDetail.setMonitor(monitorName);
                attachConfigurationDetail.setPortNumber(port);
                attachConfigurationDetail.setProfileFile(peerProfileFile);
                attachConfigurationDetail.setSwitchPerspective(false);
                Vector trcAgents = PDCoreUtil.attach(attachConfigurationDetail);
                if (trcAgents != null) {
                    Object obj;
                    int i2 = 0;
                    int agentsCount = trcAgents.size();
                    while (i2 < agentsCount) {
                        TRCAgentProxy currentAgentProxy = (TRCAgentProxy)trcAgents.get(i2);
                        Object currentAgent = LoadersUtils.locateAgentInstance((TRCAgentProxy)currentAgentProxy);
                        if (currentAgent instanceof Agent) {
                            PDCoreUtil.doAttach((Agent)currentAgent, currentAgentProxy);
                        }
                        ++i2;
                    }
                    if (trcAgents.size() == 1 && (obj = trcAgents.get(0)) instanceof TRCAgentProxy) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                ProfileUIManager.getInstance().startMonitoring((TRCAgentProxy)obj);
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
    }

    public synchronized void processExited(Process result) {
        if (this.fProcess != null) {
            this.fProcess.setActive(false);
            this.giveControl(this.fProcess, false);
        }
    }

    public synchronized void processLaunched(Process result) {
        try {
            if (result.getProcessId() == null || result.getProcessId().equals("-1")) {
                return;
            }
            if (this.fProcess == null) {
                this.fProcess = this.createProcess(result);
            }
            if (this.fProcess == null) {
                return;
            }
            Enumeration agents = result.listAgents();
            while (agents.hasMoreElements()) {
                Agent currentAgent = (Agent)agents.nextElement();
                if (this.filteredAgentList != null && !this.isAgentIncluded(currentAgent)) continue;
                this.createAgent(currentAgent, this.fProcess);
            }
            this.giveControl(this.fProcess, true);
        }
        catch (InactiveProcessException inactiveProcessException) {
            String text = TraceMessages.RAC_CERR;
            final String msg = NLS.bind((String)TraceMessages.LNCH_ERR, (Object)result.getName());
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)UIPlugin.getDefault().getViewer().getShell(), (String)TraceMessages.TRC_MSGT, (String)msg, (IStatus)err);
                }
            });
            return;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private boolean isAgentIncluded(Agent currentAgent) {
        String agentName = currentAgent.getName();
        String agentType = currentAgent.getType();
        int i = 0;
        int agentListSize = this.filteredAgentList.size();
        while (i < agentListSize) {
            Agent agent = (Agent)this.filteredAgentList.get(i);
            if (agent.getName().equals(agentName) && agent.getType().equals(agentType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Agent sendConfigurationToAgent(TRCAgentProxy agent, String host, String processId) {
        Node node;
        block5: {
            node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(agent.getProcessProxy().getNode().getPort()));
            if (node != null) break block5;
            return null;
        }
        try {
            Process p = node.getProcess(processId);
            if (p != null) {
                Agent a = p.getAgent(agent.getName());
                PDCoreUtil.setAgentConfiguration((TRCAgentProxy)agent, (Agent)a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
                return a;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    private void addEnvironment(TRCProcessProxy process) {
        int idx = 0;
        while (idx < this._processVariableList.size()) {
            Variable var = (Variable)this._processVariableList.get(idx);
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            if (!var.getName().equals("UICLASSPATH")) {
                TRCEnvironmentVariable env = factory.createTRCEnvironmentVariable();
                env.setName(var.getName());
                env.setValue(var.getValue());
                process.getEnvironmentVariables().add((Object)env);
            } else {
                process.setClasspath(var.getValue());
            }
            ++idx;
        }
    }

    private TRCAgentProxy createAgent(Agent a, TRCProcessProxy process) {
        if (process == null) {
            return null;
        }
        TRCAgentProxy agent = PDCoreUtil.createAgent(process, a);
        LoadersUtils.registerAgentListener((TRCAgentProxy)agent, (Object)this);
        return agent;
    }

    private TRCProcessProxy createProcess(Process p, TRCNode pNode) {
        try {
            TRCNode node = pNode;
            TRCMonitor monitor = node.getMonitor();
            String processId = p.getProcessId();
            String[] processAtts = LauncherUtility.resolveProcessAttributes(p);
            String pName = processAtts[0];
            String params = processAtts[1];
            String vmparam = processAtts[2];
            String rId = ((ProcessImpl)p).getUUID();
            if (rId == null) {
                rId = "";
            }
            String fileName = new StringBuffer(monitor.getName()).append("_").append(node.getName()).append("_").append(TString.change((String)pName, (String)" ", (String)"")).append(processId).append("_").append(rId).append(".").append("trcpxmi").toString();
            String folderPath = node.eResource().getURI().toString();
            Path path = new Path(folderPath);
            if (path.segmentCount() > 1) {
                folderPath = path.removeLastSegments(1).toString();
            }
            IPath filePath = new Path(folderPath).append(fileName);
            URI uri = SaveUtil.createURI((String)(String.valueOf(filePath.toString()) + "#")).trimFragment();
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            pDoc.setModified(true);
            EList pExt = pDoc.getContents();
            UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
            TRCProcessProxy process = factory.createTRCProcessProxy();
            process.setPid(Integer.parseInt(processId));
            process.setRuntimeId(rId);
            process.setName(pName);
            process.setLocation(((ProcessImpl)p).getlocation());
            process.setNode(node);
            this.addEnvironment(process);
            process.setParameters(params.trim());
            process.setVmArguments(vmparam.trim());
            process.setLaunchMode(this._launchMode);
            process.setActive(true);
            pExt.add((Object)process);
            node.getProcessProxies().add((Object)process);
            Display d = Display.getDefault();
            d.asyncExec(new Runnable(){

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource(null);
                    event.setType(128);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            this._processVariableList.clear();
            return process;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private TRCProcessProxy createProcess(Process p) {
        return this.createProcess(p, this.fNode);
    }

    public void addAgent(Agent agent) {
        if (this.filteredAgentList == null) {
            this.filteredAgentList = new ArrayList();
        }
        this.filteredAgentList.add(agent);
    }
}

