/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.reports;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceReportWizard;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

public class XMLTraceReportWizard
extends HTMLTraceReportWizard {
    public XMLTraceReportWizard() {
        this.setWindowTitle(TraceMessages._20);
        this.FILE_EXTENSION = "xml";
    }

    protected void generateAgentStatistics(List agentList, StringBuffer buffer) {
        int idx = 0;
        while (idx < agentList.size()) {
            TRCAgentProxy agent = (TRCAgentProxy)agentList.get(idx);
            buffer.append(newLine).append("<Agent name=\"").append(this.replaceEntities(agent.getName())).append("\"").append(" type=\"").append(agent.getType()).append("\"").append(" runtimeId=\"").append(agent.getRuntimeId()).append("\"").append(" startTime=\"").append(agent.getStartTime()).append("\"").append(" stopTime=\"").append(agent.getStopTime()).append("\"").append(" collectionMode=\"").append(agent.getCollectionMode()).append("\"").append(">");
            this.generateStatistics(agent, buffer);
            buffer.append(newLine).append("</Agent>");
            ++idx;
        }
    }

    protected void generateStatistics(TRCAgentProxy agent, StringBuffer buffer) {
        TRCProcess proc = PerftraceUtil.getProcess(agent.getAgent());
        if (proc != null) {
            buffer.append(newLine).append("<process pid=\"").append(proc.getPid()).append("\"").append(" id=\"").append(proc.getId()).append("\"").append(" startTime=\"").append(proc.getStartTime()).append("\"").append(" lastEventTime=\"").append(proc.getStopTime()).append("\"").append(" baseTime=\"").append(proc.getBaseTime()).append("\"").append(" cumulativeTime=\"").append(proc.getCumulativeTime()).append("\"").append(" calls=\"").append(proc.getCalls()).append("\"").append(" totalSize=\"").append(proc.getTotalSize()).append("\"").append(" totalInstances=\"").append(proc.getTotalInstances()).append("\"");
            if (proc.getClassClass() != null) {
                buffer.append(" classClass=\"").append(proc.getClassClass().getId()).append("\"");
            }
            buffer.append("/>");
        }
        Object[] threads = PerftraceUtil.getAllThreads((EObject)agent);
        int idx = 0;
        while (idx < threads.length) {
            TRCThread thread = (TRCThread)threads[idx];
            buffer.append(newLine).append("<threads name=\"").append(thread.getName()).append("\"").append(" id=\"").append(thread.getId()).append("\"").append(" startTime=\"").append(thread.getStartTime()).append("\"").append(" stopTime=\"").append(thread.getStopTime()).append("\"").append(" maxStackDepth=\"").append(thread.getMaxStackDepth()).append("\"").append("/>");
            ++idx;
        }
        Object[] packages = PerftraceUtil.getAllPackages((EObject)agent);
        int idx2 = 0;
        while (idx2 < packages.length) {
            TRCPackage pack = (TRCPackage)packages[idx2];
            buffer.append(newLine).append("<packages name=\"").append(pack.getName()).append("\"").append(" baseTime=\"").append(pack.getBaseTime()).append("\"").append(" cumulativeTime=\"").append(pack.getCumulativeTime()).append("\"").append(" calls=\"").append(pack.getCalls()).append("\"").append(" totalSize=\"").append(pack.getTotalSize()).append("\"").append(" totalInstances=\"").append(pack.getTotalInstances()).append("\"").append(" collectedSize=\"").append(pack.getCollectedSize()).append("\"").append(" collectedInstances=\"").append(pack.getCollectedInstances()).append("\"").append(">");
            this.generateClassStatistics(pack, buffer);
            buffer.append(newLine).append("</packages>");
            ++idx2;
        }
    }

    protected void generateClassStatistics(TRCPackage pack, StringBuffer buffer) {
        for (TRCClass cls : pack.getClasses()) {
            Iterator iterator;
            buffer.append(newLine).append("    <classes name=\"").append(this.replaceEntities(cls.getName())).append("\"").append(" id=\"").append(cls.getId()).append("\"").append(" loadTime=\"").append(cls.getLoadTime()).append("\"").append(" baseTime=\"").append(cls.getBaseTime()).append("\"").append(" cumulativeTime=\"").append(cls.getCumulativeTime()).append("\"").append(" calls=\"").append(cls.getCalls()).append("\"").append(" totalSize=\"").append(cls.getTotalSize()).append("\"").append(" totalInstances=\"").append(cls.getTotalInstances()).append("\"").append(" collectedSize=\"").append(cls.getCollectedSize()).append("\"").append(" collectedInstances=\"").append(cls.getCollectedInstances()).append("\"").append(" loadedBy=\"").append(cls.getLoadedBy() == null ? "null" : Integer.valueOf(cls.getLoadedBy().getId())).append("\"");
            if (cls.getSourceInfo() != null) {
                buffer.append(" sourceInfo=\"").append(cls.getSourceInfo().getLocation()).append("\"");
            }
            if ((iterator = cls.getClassObjects().iterator()).hasNext()) {
                buffer.append(" classObjects=\"");
                while (iterator.hasNext()) {
                    buffer.append(((TRCObject)iterator.next()).getId()).append(" ");
                }
                buffer.append("\"");
            }
            buffer.append(">");
            this.generateMethodStatistics(cls, buffer);
            buffer.append(newLine).append("    </classes>");
        }
    }

    protected void generateMethodStatistics(TRCClass cls, StringBuffer buffer) {
        for (TRCMethod meth : cls.getMethods()) {
            buffer.append(newLine).append("      <methods name=\"").append(this.replaceEntities(meth.getName())).append("\"").append(" id=\"").append(meth.getId()).append("\"").append(" signature=\"").append(meth.getSignature()).append("\"").append(" baseTime=\"").append(meth.getBaseTime()).append("\"").append(" cumulativeTime=\"").append(meth.getCumulativeTime()).append("\"").append(" calls=\"").append(meth.getCalls()).append("\"").append("/>");
        }
    }

    protected String printHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(newLine).append("<Contents ");
        return buffer.toString();
    }

    protected String printFooter() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(newLine).append("</Contents>").append(newLine);
        return buffer.toString();
    }

    protected String printTitle(String title) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" name=\"").append(this.replaceEntities(title)).append("\">");
        return buffer.toString();
    }
}

